    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
        $options = array(
            'home_page_title' => sanitize_text_field($_POST['home_page_title']),
            'phone1' => sanitize_text_field($_POST['phone1']),
            'phone2' => sanitize_text_field($_POST['phone2']),
            'email' => sanitize_email($_POST['email']),
            'location' => sanitize_text_field($_POST['location']),
            'website' => esc_url_raw($_POST['website']),
        );

        // Save the options to the database
        update_option('lga_tools_contact', $options);

        // Redirect to avoid form resubmission
        wp_redirect($_SERVER['REQUEST_URI'] . "&s=1");
        exit;
    }
    if (isset($_GET["s"])) {
        echo "<div class='alert alert-success'>Data has been saved successfully.</div>";
    }
    $options = get_option("lga_tools_contact");
    if ($options != "") {
        extract($options);
    }
    ?>

    <div class="ctn">
        <form method="post" action="">
            <div class="rps">
                <h3>Banner Data</h3>
                <div class="inn">
                    <div class="inp input-group">
                        <label><strong>Banner Title:</strong></label>
                        <input type="text" name="home_page_title" value="<?php echo isset($options['home_page_title']) ? esc_attr($options['home_page_title']) : ''; ?>" placeholder="Enter Banner Title" style="width: 100%;padding:8px">
                    </div>
                </div>
            </div>
            <div class="rps">
                <h3>Contact Information</h3>
                <div class="inn">
                    <div class="inp">
                        <label>Mobile 1:</label>
                        <div>
                            <input type="text" name="phone1" value="<?php echo isset($options['phone1']) ? esc_attr($options['phone1']) : ''; ?>" placeholder="First Phone No." class="field">
                        </div>
                    </div>
                    <hr>
                    <div class="inp">
                        <label>Mobile 2:</label>
                        <div>
                            <input type="text" name="phone2" value="<?php echo isset($options['phone2']) ? esc_attr($options['phone2']) : ''; ?>" placeholder="Second Phone No." class="field">
                        </div>
                    </div>
                    <hr>
                    <div class="inp">
                        <label>Email Address:</label>
                        <div>
                            <input type="text" name="email" value="<?php echo isset($options['email']) ? esc_attr($options['email']) : ''; ?>" placeholder="johnsmith@gmail.com" class="field">
                        </div>
                    </div>
                    <hr>
                    <div class="inp">
                        <label>Address:</label>
                        <div>
                            <textarea name="location" placeholder="Address" class="field" rows="3"><?php echo isset($options['location']) ? esc_textarea($options['location']) : ''; ?></textarea>
                        </div>
                    </div>

                </div>
            </div>
            <div class="rps">
                <h3>Other Settings</h3>
                <div class="inn">
                    <div class="form-fl" style="display:block">
                        <div class="inp">
                            <label>
                                Receiving Email:
                            </label>
                            <div>
                                <input type="text" name="r_email" value="<?php echo isset($options['r_email']) ? esc_attr($options['r_email']) : ''; ?>" placeholder="Receiving Email" class="field">
                                <div class="inp-info">
                                    <p>
                                        <strong>Note:- </strong> If you want to receive the message on multiple emails, then enter email addresses separated by comma.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dg-btns btn-right">
                <button type="submit" name="submit">Save</button>
            </div>
        </form>
    </div>

    <style>
        .inb {
            display: flex;
            justify-content: space-between;
            align-items: center;
            /* background-color: whitesmoke; */
            padding: 10px;
            border-radius: 5px;
            /* margin-bottom: 20px; */
        }

        .ctt {
            background-color: white;
            width: 100%;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-radius: 5px;
        }

        .inp {
            border-bottom: none;
        }

        .rps {
            background-color: #fbfbfb;
            margin-bottom: 25px;
            border-radius: 10px;
        }

        .inn {
            padding: 20px;
        }

        .rps h3 {
            background: linear-gradient(to right, rgb(225, 225, 225), rgb(255, 214, 182));
            padding: 10px;
            border-radius: 10px 10px 0px 0px;
            color: black;
            text-align: center;
        }
    </style>