<style>
    .dash {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap;
    }

    .dash>div {
        box-sizing: border-box;
        flex: 0 0 48%;
        margin-bottom: 15px;
        padding: 20px;
        border-radius: 12px;
        display: flex;
        justify-content: space-between;
        transition: opacity .7s ease-in-out;
    }

    .dash h3 {
        font-size: 15px;
        font-weight: 500;
        color: #fff;
        transition: color 1s;
    }

    .dash .n {
        font-size: 36px;
        font-weight: 500;
        color: #fff;
        transition: color 1s;
    }

    .dash>div span.dashicons::before {
        font-size: 48px;
    }

    .dash>div span.dashicons {
        display: inline-flex;
        background: transparent;
        align-items: center;
        justify-content: center;
        border-radius: 100%;
        color: #fff;
        margin-top: 20px;
        transition: transform .7s ease-in-out;
    }

    .dash>div:nth-child(1) {
        background: #00c689;
    }

    .dash>div:nth-child(2) {
        background: #3da5f4;
    }

    .dash>div:nth-child(3) {
        background: #f1536e;
    }

    .dash>div:nth-child(4) {
        background: #fda006;
    }

    .dash>div:nth-child(5) {
        background: #2164cc;
    }

    .dash>div:nth-child(6) {
        background: #994fe7;
    }

    .dash>div {
        cursor: pointer;
    }

    .dash>div:hover span.dashicons {
        transform: rotate(360deg);
    }

    .dash>div:hover {
        opacity: 0.8;
    }

    .dash>div:hover h3,
    .dash>div:hover .n {
        color: #000;
    }

    .divider {
        position: relative;
        margin: 50px 0px;
        height: 1px;
    }

    .div-transparent:before {
        content: "";
        position: absolute;
        top: 0;
        left: 5%;
        right: 5%;
        width: 90%;
        height: 1px;
        background-image: linear-gradient(to right, transparent, rgb(48, 49, 51), transparent);
    }

    .div-dot:after {
        content: "";
        position: absolute;
        z-index: 1;
        top: -9px;
        left: calc(50% - 9px);
        width: 18px;
        height: 18px;
        background-color: #2271b1;
        border: 1px solid rgb(48, 49, 51);
        border-radius: 50%;
        box-shadow: inset 0 0 0 2px white, 0 0 0 4px white;
    }

    .dash h3 {
        margin: 0rem 0rem 1rem 0 !important;
    }

    .most_viewed {
        width: 100%;
        border-collapse: collapse;
        ;
    }

    .most_viewed .h {
        background: #000;
        color: #fff;
    }

    .most_viewed .h td {
        padding: 10px 6px;
    }

    .most_viewed td {
        padding: 10px;
        border: 1px solid #ccc;
        text-align: justify;
    }

    .most_viewed tr:nth-child(even) {
        background: #f6f7f7
    }

    .most_viewed tr:not(.h):hover {
        background: #f0f0f1;
    }

    .most_viewed tr a {
        font-size: 13px;
    }

    .most_viewed .ttl a:hover {
        color: darkblue;
    }

    .most_viewed .ctg a {
        font-size: 13px;
    }

    .most_viewed .vw {
        text-align: center;
        font-weight: bold;
        font-size: 13px;
    }

    html {
        background: #000;
    }

    .hdd hr {
        border: 0;
        width: 100%;
        height: 0;
        border-top: 0.3rem dotted darkgrey;
        position: relative;
        overflow: visible;
        margin: 2rem 0;
    }

    .hdd hr:before {
        animation: move 10s infinite linear;
        position: absolute;
        top: -14px;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' height='571.11' width='541.6'%3E%3Cpath style='fill:%23ffcc00' d='M535.441,412.339A280.868,280.868 0 1,1 536.186,161.733L284.493,286.29Z'/%3E%3C/svg%3E");
        background-size: 22px;
        background-repeat: no-repeat;
        background-position: calc(100% + 24px) 0;
        content: ' ';
        height: 24px;
    }

    .hdd hr:after {
        animation: move 10s 1s infinite linear;
        position: absolute;
        top: -14px;
        left: 0;
        right: 0;
        bottom: 0;
        background-size: 24px;
        background-repeat: no-repeat;
        background-position: calc(100% + 24px) 0;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%2300c689'%3E%3Cpath d='M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2zm1 15h-2v-2h2zm0-4h-2V7h2z'/%3E%3C/svg%3E");
        content: ' ';
        height: 24px;
    }

    @keyframes move {
        0% {
            background-position: 0 0;
        }
    }
</style>
<div class="ctn">
    <?php
    // Safely fetch blog post count
    $blogs_count = wp_count_posts('post');
    $blogs_count = isset($blogs_count->publish) ? $blogs_count->publish : 0;

    // Safely fetch project count from saved option
    $project_data = get_option('project_data');
    $projects_count = (is_array($project_data) && !empty($project_data)) ? count($project_data) : 0;
    ?>

    <div class="dash">
        <div>
            <div>
                <h3>Total Blogs</h3>
                <span class="n"><?php echo esc_html($blogs_count); ?></span>
            </div>
            <div><span class="dashicons dashicons-welcome-write-blog"></span></div>
        </div>

        <div>
            <div>
                <h3>Total Projects</h3>
                <?php
                // Fetch published projects using get_posts
                $projects = get_posts([
                    'post_type' => 'project',
                    'posts_per_page' => -1,
                    'post_status' => 'publish'
                ]);
                $projects_count = is_array($projects) ? count($projects) : 0;
                ?>
                <span class="n"><?php echo esc_html($projects_count); ?></span>
            </div>
            <div><span class="dashicons dashicons-portfolio"></span></div>
        </div>

        <!-- <div>
            <div>
                <h3>Total Services</h3>
                <span class="n"><?php echo esc_html($services_count); ?></span>
            </div>
            <div><span class="dashicons dashicons-admin-tools"></span></div>
        </div> -->
    </div>

    <div class="hdd">
        <hr />
    </div>
</div>



<script>
    (function($) {
        $(document).ready(function() {
            $("._select_most_views").change(function() {
                var period = $(this).val();
                var type = $(this).attr("data-type");
                var _class = (type == "post") ? ".most_viewed.posts tbody" : ".most_viewed.tools tbody";
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: {
                        action: 'get_most_viewed_via_period',
                        period: period,
                        type: type
                    },
                    beforeSend: function() {
                        $(_class).html('<tr><td colspan="5" style="text-align:center;">Loading...</td></tr>');
                    },
                    success: function(response) {
                        $(_class).html(response);
                    },
                    error: function() {
                        $(_class).html('<tr><td colspan="5" style="text-align:center;">Error loading data.</td></tr>');
                    }
                });
            });
        });
    })(jQuery);
</script>