<?php
$post_id = isset($_GET['i']) ? intval($_GET['i']) : 0;
$project = $post_id ? get_post($post_id) : null;

if (isset($_POST['submit_project'])) {
    $title = sanitize_text_field($_POST['project_title']);
    $location = sanitize_text_field($_POST['project_location']);
    $employer = sanitize_text_field($_POST['project_employer']);
    $engineer = sanitize_text_field($_POST['project_engineer']);
    $completion_date = sanitize_text_field($_POST['project_completion_date']);
    $funding = sanitize_text_field($_POST['project_funding']);
    $details = wp_kses_post($_POST['project_details']);
    $banner = intval($_POST['project_banner']);
    $status = sanitize_text_field($_POST['project_status']);
    $post_id = $post_id ?: 0;
    $project_slider = isset($_POST['project_slider']) ? array_map('intval', $_POST['project_slider']) : [];
    $project_slider = $project_slider ?: [];



    // Handle design files upload
    $design_files_data = [];

    if (!empty($_POST['design_files'])) {
        foreach ($_POST['design_files'] as $i => $file) {
            $name = !empty($file['name']) ? sanitize_text_field($file['name']) : '';
            $url  = !empty($file['url']) ? esc_url_raw($file['url']) : '';

            // Handle file upload from design_files[$i][file]
            if (
                isset($_FILES['design_files']['name'][$i]['file']) &&
                !empty($_FILES['design_files']['name'][$i]['file']) &&
                $_FILES['design_files']['error'][$i]['file'] == UPLOAD_ERR_OK
            ) {
                require_once(ABSPATH . 'wp-admin/includes/file.php');
                require_once(ABSPATH . 'wp-admin/includes/media.php');
                require_once(ABSPATH . 'wp-admin/includes/image.php');

                $file_array = [
                    'name'     => $_FILES['design_files']['name'][$i]['file'],
                    'type'     => $_FILES['design_files']['type'][$i]['file'],
                    'tmp_name' => $_FILES['design_files']['tmp_name'][$i]['file'],
                    'error'    => $_FILES['design_files']['error'][$i]['file'],
                    'size'     => $_FILES['design_files']['size'][$i]['file'],
                ];

                $field_name = 'design_files_' . $i;
                $_FILES[$field_name] = $file_array;

                add_filter('upload_mimes', function ($mimes) {
                    $mimes['zip'] = 'application/zip';
                    $mimes['rar'] = 'application/x-rar-compressed';
                    $mimes['pdf'] = 'application/pdf';
                    return $mimes;
                });

                $attachment_id = media_handle_upload($field_name, 0);
                unset($_FILES[$field_name]);

                if (!is_wp_error($attachment_id)) {
                    $url = wp_get_attachment_url($attachment_id);
                }
            }

            if (!empty($name) || !empty($url)) {
                $design_files_data[] = [
                    'name' => $name,
                    'url'  => $url,
                ];
            }
        }
    }

    update_post_meta($post_id, 'project_design_files', $design_files_data);


    // Prepare and insert/update post
    $post_data = [
        'post_title'   => $title,
        'post_type'    => 'project',
        'post_status'  => 'publish',
        'post_content' => $details,
        'meta_input'   => [
            'project_status'          => $status,
            'project_location'        => $location,
            'project_employer'        => $employer,
            'project_engineer'        => $engineer,
            'project_completion_date' => $completion_date,
            'project_funding'         => $funding,
            'project_banner'          => $banner,
            'project_slider'          => $project_slider,

        ]
    ];

    if (!empty($title)) {
        if ($post_id and $post_id > 0) {
            $post_data['ID'] = $post_id;
            wp_update_post($post_data);
        } else {
            $post_id = wp_insert_post($post_data);
        }

        // Save design files meta
        update_post_meta($post_id, 'project_design_files', $design_files_data);

        wp_redirect(admin_url('admin.php?page=smecon-settings&pg=projects'));
        exit;
    } else {
        echo '<div class="notice notice-error is-dismissible"><p>Title is required.</p></div>';
    }
    // Save project image slider images
    if (isset($_POST['project_slider']) && is_array($_POST['project_slider'])) {
        $slider_images = array_map('intval', $_POST['project_slider']);
        update_post_meta($post_id, 'project_slider', $slider_images);
    } else {
        delete_post_meta($post_id, 'project_slider');
    }
}

$title = $project ? $project->post_title : '';
$details = $project ? $project->post_content : '';
$location = get_post_meta($post_id, 'project_location', true);
$employer = get_post_meta($post_id, 'project_employer', true);
$engineer = get_post_meta($post_id, 'project_engineer', true);
$completion_date = get_post_meta($post_id, 'project_completion_date', true);
$funding = get_post_meta($post_id, 'project_funding', true);
$status = get_post_meta($post_id, 'project_status', true) ?: 'in-hand';
$banner_id = get_post_meta($post_id, 'project_banner', true);
$banner_url = $banner_id ? wp_get_attachment_url($banner_id) : get_template_directory_uri() . '/admin/assets/img/trans.png';


if (isset($_POST['submit'])) {
    $post_id = $_GET['id'] ?? 0;

    // Other fields saving...
    update_post_meta($post_id, 'project_title', sanitize_text_field($_POST['project_title']));
    // ... add this part right after those

    if (isset($_POST['project_slider'])) {
        $valid_sliders = array_filter($_POST['project_slider'], function ($item) {
            return !empty($item);
        });
        update_post_meta($post_id, 'project_slider', $valid_sliders);
    }

    // Redirect or success message
}

?>
<div class="dg-btns btn-right" style="position: absolute;right:20px;top:17px">
    <a href="?page=smecon-settings&pg=projects" class="dg-btn">Project list</a>
</div>
<form method="post" enctype="multipart/form-data">
    <div class="project-block">

        <div class="status-toggle">
            <input type="hidden" name="project_status" value="<?php echo esc_attr($status); ?>">
            <div class="toggle-options">
                <span class="status-option <?php echo $status === 'in-hand' ? 'active' : ''; ?>" data-status="in-hand">In Hand</span>
                <span class="status-option <?php echo $status === 'completed' ? 'active' : ''; ?>" data-status="completed">Completed</span>
                <div class="status-slider <?php echo $status === 'completed' ? 'right' : ''; ?>"></div>
            </div>
        </div>

        <div class="inp input-group">
            <label><strong>Featured Image:</strong></label>
            <div class="img" style="width: 300px; flex:0;">
                <p><strong>Image Size: 400 x 300</strong></p>
                <div class="img up_img" style="width: 300px;">
                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                    <img src="<?php echo esc_url($banner_url); ?>">
                    <a href="#" class="button rudr-upload">Upload image</a>
                    <input type="hidden" name="project_banner" value="<?php echo esc_attr($banner_id); ?>">
                </div>
            </div>
        </div>

        <div class="inp input-group">
            <label><strong>Title:</strong></label>
            <input type="text" name="project_title" value="<?php echo esc_attr($title); ?>" placeholder="Project Title">
        </div>

        <div class="inp input-group">
            <label><strong>Location:</strong></label>
            <input type="text" name="project_location" value="<?php echo esc_attr($location); ?>" placeholder="Location">
        </div>

        <div class="inp input-group">
            <label><strong>Employer:</strong></label>
            <input type="text" name="project_employer" value="<?php echo esc_attr($employer); ?>" placeholder="Employer">
        </div>

        <div class="inp input-group">
            <label><strong>Engineer:</strong></label>
            <input type="text" name="project_engineer" value="<?php echo esc_attr($engineer); ?>" placeholder="Engineer Name">
        </div>

        <div class="inp input-group">
            <label><strong>Completion Date:</strong></label>
            <input type="text" name="project_completion_date" value="<?php echo esc_attr($completion_date); ?>" placeholder="e.g. 2023-12-31">
        </div>

        <div class="inp input-group">
            <label><strong>Funding:</strong></label>
            <input type="text" name="project_funding" value="<?php echo esc_attr($funding); ?>" placeholder="e.g. $100,000">
        </div>

        <div class="inp input-group">
            <label><strong>Design Files:</strong></label>
            <div style="width:100%;display:flex;justify-content:space-between;align-items:flex-start;">
                <div style="flex:1;">
                    <table id="design-files-table" style="width:100%;border-collapse:collapse;">
                        <thead>
                            <tr>
                                <th style="border:1px solid #ccc;padding:8px;">File</th>
                                <th style="border:1px solid #ccc;padding:8px;">Upload</th>
                                <th style="border:1px solid #ccc;padding:8px;">Remove</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $design_files = get_post_meta($post_id, 'project_design_files', true);
                            if (!empty($design_files) && is_array($design_files)) {
                                foreach ($design_files as $i => $file) {
                                    $file_url = !empty($file['url']) ? esc_url($file['url']) : '';
                                    $file_name = !empty($file['name']) ? esc_html($file['name']) : '';
                                    echo '<tr>
                                <td style="border:1px solid #ccc;padding:8px;">
                                    <input type="text" name="design_files[' . $i . '][name]" value="' . $file_name . '" style="width:100%;" placeholder="File Name">
                                </td>
                                <td style="border:1px solid #ccc;padding:8px;">
                                    <input type="file" name="design_files[' . $i . '][file]" accept=".pdf,.zip,.rar">
                                    <input type="hidden" name="design_files[' . $i . '][url]" value="' . $file_url . '">
                                </td>
                                <td style="border:1px solid #ccc;padding:8px;">
                                    <button type="button" class="remove-design-row button">Remove</button>
                                </td>
                            </tr>';
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                    <div>
                        <a href="#" id="add-design-row" class="dgh-add-row-desktop dg-btn" style="float:right;">+ Add</a>
                    </div>
                </div>
            </div>
        </div>

        <script>
            jQuery(document).ready(function($) {
                $('#add-design-row').on('click', function(e) {
                    e.preventDefault();
                    var idx = $('#design-files-table tbody tr').length;
                    var row = `<tr>
                        <td style="border:1px solid #ccc;padding:8px;">
                            <input type="text" name="design_files[` + idx + `][name]" placeholder="File Name" style="width:100%;">
                        </td>
                        <td style="border:1px solid #ccc;padding:8px;">
                            <input type="file" name="design_files[` + idx + `][file]" accept=".pdf,.zip,.rar">
                            <input type="hidden" name="design_files[` + idx + `][url]" value="">
                        </td>
                        <td style="border:1px solid #ccc;padding:8px;">
                            <button type="button" class="remove-design-row button">Remove</button>
                        </td>
                    </tr>`;
                    $('#design-files-table tbody').append(row);
                });
                $('#design-files-table').on('click', '.remove-design-row', function() {
                    $(this).closest('tr').remove();
                });
            });
        </script>




        <div class="inp input-group">
            <label><strong>Details:</strong></label>
            <?php
            $editor_settings = array(
                'textarea_name' => 'project_details',
                'textarea_rows' => 20,
                'media_buttons' => true,
            );
            wp_editor($details, 'project_details', $editor_settings);
            ?>
        </div>

        <div class="rps">
            <h3>Project Image Slider</h3>
            <div class="inn">
                <div class="note">
                    <p>
                        <strong>Shortcode For Project Slider:</strong>
                        <code id="copied-text">[project_slider]</code>
                        <span><button for="copy" class="copy-button"><i class="dashicons dashicons-admin-page"></i></button></span>
                    </p>
                </div>

                <div id="project-slider-container">
                    <?php
                    $project_slider = get_post_meta($post_id, 'project_slider', true);
                    if (!is_array($project_slider)) $project_slider = [];

                    foreach ($project_slider as $img_id) :
                        $img_id = intval($img_id);
                    ?>
                        <div class="inp input-group slider-item">
                            <div class="img">
                                <p><strong>Slider Image Size: 800 x 400</strong></p>
                                <div class="up_img" style="width: 250px;">
                                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                    <img src="<?php echo $img_id ? esc_url(wp_get_attachment_url($img_id)) : get_template_directory_uri() . '/admin/assets/img/trans.png'; ?>" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                    <a href="#" class="button rudr-upload">Upload image</a>
                                    <input type="hidden" name="project_slider[]" value="<?php echo esc_attr($img_id); ?>">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Template (hidden) -->
                <div class="inp input-group slider-item template" id="project-slider-template" style="display: none;">
                    <div class="img">
                        <p><strong>Slider Image Size: 800 x 400</strong></p>
                        <div class="up_img" style="width: 250px;">
                            <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                            <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                            <a href="#" class="button rudr-upload">Upload image</a>
                            <input type="hidden" name="project_slider[]" value="">
                        </div>
                    </div>
                </div>

                <a href="#" class="dgh-add-row-project dg-btn" style="float:left;">+ Add Slider Image</a>
            </div>
        </div>

        <div class="dg-btns btn-right">
            <button type="submit" name="submit_project" class="button button-primary">Save Project</button>
        </div>

    </div>

</form>

<script>
    document.querySelector('.copy-button').addEventListener('click', function() {
        const code = document.querySelector('#copied-text');
        navigator.clipboard.writeText(code.textContent).then(function() {
            alert('Shortcode copied to clipboard!');
        }, function(err) {
            console.error('Error copying text: ', err);
        });
    });
</script>

<style>
    #project-slider-container {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 20px;
    }

    #project-slider-container .inp {
        margin: 0;
    }

    .copy-button {
        background: #4caf50;
        color: white;
        border: none;
        padding: 3px 8px;
        cursor: pointer;
        border-radius: 4px;
    }

    .project-block {
        background: #fdfdfd;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 30px;
        border: 1px solid #e2e2e2;
    }

    .inp {
        margin-bottom: 20px;
    }

    .inp label {
        display: block;
        font-weight: bold;
        margin-bottom: 6px;
    }

    .status-toggle {
        margin-bottom: 20px;
    }

    .toggle-options {
        display: flex;
        border: 1px solid #ccc;
        border-radius: 20px;
        overflow: hidden;
        width: 160px;
        position: relative;
    }

    .toggle-options span {
        flex: 1;
        text-align: center;
        padding: 8px 0;
        cursor: pointer;
    }

    .status-option.active {
        background: #4caf50;
        color: white;
    }

    .status-slider {
        position: absolute;
        top: 0;
        bottom: 0;
        width: 50%;
        background: #4caf50;
        z-index: -1;
        transition: all 0.3s ease-in-out;
        border-radius: 20px;
    }

    .status-slider.right {
        left: 50%;
    }

    .input-group {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 20px;
        flex-wrap: wrap;
    }

    .input-group input,
    .input-group textarea {
        flex: 1;
        min-width: 250px;
        padding: 8px;
        border: 1px solid #ccc;
        border-radius: 4px;
        width: 100%;
    }
</style>

<script>
    jQuery(document).ready(function($) {
        $('.status-option').click(function() {
            var status = $(this).data('status');
            $(this).siblings().removeClass('active');
            $(this).addClass('active');
            $(this).closest('.status-toggle').find('input[name="project_status"]').val(status);
            $(this).closest('.toggle-options').find('.status-slider').toggleClass('right', status === 'completed');
        });

        // Media uploader
        $('.rudr-upload').on('click', function(e) {
            e.preventDefault();
            var button = $(this);
            var custom_uploader = wp.media({
                title: 'Select Banner',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            }).on('select', function() {
                var attachment = custom_uploader.state().get('selection').first().toJSON();
                button.prev('img').attr('src', attachment.url);
                button.next('input').val(attachment.id);
            }).open();
        });

        $('.rudr-remove').on('click', function(e) {
            e.preventDefault();
            var container = $(this).closest('.up_img');
            container.find('img').attr('src', '<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png');
            container.find('input').val('');
        });
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {

        // Function to initialize media uploader
        function initMediaUpload(button) {
            if (!button) return;

            button.addEventListener('click', function(e) {
                e.preventDefault();
                let uploader = wp.media({
                    title: 'Select or Upload an Image',
                    button: {
                        text: 'Use this image'
                    },
                    multiple: false
                });

                uploader.on('select', function() {
                    const attachment = uploader.state().get('selection').first().toJSON();
                    const img = button.parentElement.querySelector('img');
                    const input = button.parentElement.querySelector('input[type="hidden"]');
                    img.src = attachment.url;
                    input.value = attachment.url;
                });

                uploader.open();
            });
        }

        // Function to attach remove button logic
        function initRemoveButton(removeBtn) {
            if (!removeBtn) return;
            removeBtn.addEventListener('click', function(e) {
                e.preventDefault();
                removeBtn.closest('.input-group').remove();
            });
        }

        // Handle "Add Row" button
        const addBtn = document.querySelector('.dgh-add-row-project');
        const template = document.querySelector('#project-slider-template .input-group');
        const container = document.querySelector('#project-slider-container');

        if (addBtn && template && container) {
            addBtn.addEventListener('click', function(e) {
                e.preventDefault();

                const clone = template.cloneNode(true);
                clone.style.display = 'block';

                // Reset default image and input value
                const img = clone.querySelector('img');
                const input = clone.querySelector('input[type="hidden"]');
                img.src = img.getAttribute('data-def');
                input.value = '';

                // Attach events
                initMediaUpload(clone.querySelector('.rudr-upload'));
                initRemoveButton(clone.querySelector('.rudr-remove'));

                // Append to container
                container.appendChild(clone);
            });
        }

        // Initialize events for existing rows
        document.querySelectorAll('#project-slider-container .input-group').forEach(function(group) {
            initMediaUpload(group.querySelector('.rudr-upload'));
            initRemoveButton(group.querySelector('.rudr-remove'));
        });

    });
</script>

<script>
jQuery(document).ready(function($) {

    // ADD NEW SLIDER IMAGE
    $('.dgh-add-row-project').on('click', function(e) {
        e.preventDefault();
        let template = $('#project-slider-template').clone();
        template.removeAttr('id');
        template.removeClass('template');
        template.show();
        $('#project-slider-container').append(template);
    });

    // DELETE SLIDER IMAGE BLOCK
    $('#project-slider-container').on('click', '.rudr-remove', function(e) {
        e.preventDefault();
        $(this).closest('.slider-item').remove();
    });

});
</script>
