<?php
$services = get_option('services_data', []);
$index = isset($_GET['i']) ? intval($_GET['i']) : null;
$service = ($index !== null && isset($services[$index])) ? $services[$index] : null;

if (isset($_POST['submit_service'])) {
    $title = sanitize_text_field($_POST['service_title']);
    $description = sanitize_text_field($_POST['service_description']);
    $details = wp_kses_post($_POST['service_details']);
    $banner = intval($_POST['service_banner']);

    if (!empty($title)) {
        $new_service = [
            'service_title' => $title,
            'service_description' => $description,
            'service_details' => $details,
            'service_banner' => $banner,
        ];

        if ($index !== null && isset($services[$index])) {
            $services[$index] = $new_service; // Update existing
        } else {
            $services[] = $new_service; // Add new
        }

        update_option('services_data', $services);

        wp_redirect(admin_url('admin.php?page=smecon-settings&pg=services'));
        exit;
    } else {
        echo '<div class="notice notice-error is-dismissible"><p>Title is required.</p></div>';
    }
}

$title = $service['service_title'] ?? '';
$description = $service['service_description'] ?? '';
$details = $service['service_details'] ?? '';
$banner_id = $service['service_banner'] ?? 0;
$banner_url = $banner_id ? wp_get_attachment_url($banner_id) : get_template_directory_uri() . '/admin/assets/img/trans.png';
?>

<div class="dg-btns btn-right" style="position: absolute;right:20px;top:17px">
    <a href="?page=smecon-settings&pg=services" class="dg-btn">Service List</a>
</div>

<form method="post">
    <div class="project-block">
        <div class="inp input-group">
            <label><strong>Banner Image:</strong></label>
            <div class="img" style="width: 300px; flex:0;">
                <p><strong>Image Size: 400 x 300</strong></p>
                <div class="img up_img" style="width: 300px;">
                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                    <img src="<?php echo esc_url($banner_url); ?>">
                    <a href="#" class="button rudr-upload">Upload image</a>
                    <input type="hidden" name="service_banner" value="<?php echo esc_attr($banner_id); ?>">
                </div>
            </div>
        </div>

        <div class="inp input-group">
            <label><strong>Title:</strong></label>
            <input type="text" name="service_title" value="<?php echo esc_attr($title); ?>" placeholder="Service Title">
        </div>

        <div class="inp input-group">
            <label><strong>Description:</strong></label>
            <input type="text" name="service_description" value="<?php echo esc_attr($description); ?>" placeholder="Short Description">
        </div>

        <div class="inp input-group">
            <label><strong>Details:</strong></label>
            <?php
            wp_editor($details, 'service_details', [
                'textarea_name' => 'service_details',
                'textarea_rows' => 20,
                'media_buttons' => true,
            ]);
            ?>
        </div>

        <div class="dg-btns btn-right">
            <button type="submit" name="submit_service" class="button button-primary">Save Service</button>
        </div>
    </div>
</form>

<script>
    jQuery(document).ready(function($) {
        $('.rudr-upload').on('click', function(e) {
            e.preventDefault();
            var button = $(this);
            var custom_uploader = wp.media({
                title: 'Select Banner',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            }).on('select', function() {
                var attachment = custom_uploader.state().get('selection').first().toJSON();
                button.prev('img').attr('src', attachment.url);
                button.next('input').val(attachment.id);
            }).open();
        });

        $('.rudr-remove').on('click', function(e) {
            e.preventDefault();
            var container = $(this).closest('.up_img');
            container.find('img').attr('src', '<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png');
            container.find('input').val('');
        });
    });
</script>

<style>
    .input-group input, .input-group textarea {
    flex: 1;
    min-width: 250px;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    width: 100%;
}
</style>