<?php
// Delete service if "del" is set
$services = get_option('services_data', []);

if (isset($_GET["del"])) {
    $del = intval($_GET["del"]);
    if (isset($services[$del])) {
        unset($services[$del]);
        update_option('services_data', array_values($services));
        echo '<div class="notice notice-success"><p>Service deleted successfully.</p></div>';
    } else {
        echo '<div class="notice notice-error"><p>Invalid service index.</p></div>';
    }
}
?>

<div class="dg-btns btn-right" style="position: absolute; right: 20px; top: 17px;">
    <a href="?page=smecon-settings&pg=services&sb=add" class="dg-btn">Add Service</a>
</div>

<table class="dg-table" style="margin-top: 20px;">
    <thead>
        <tr>
            <th style="width: 40px;">Sr.</th>
            <th style="text-align: left;">Service Name</th>
            <th style="width: 200px;">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($services)) :
            $sr = 1;
            foreach ($services as $index => $service) :
                $title = esc_html($service['service_title'] ?? 'N/A');
        ?>
                <tr>
                    <td><?php echo $sr++; ?></td>
                    <td style="text-align: left;"><?php echo $title; ?></td>
                    <td>
                        <a href="?page=smecon-settings&pg=services&sb=add&i=<?php echo $index; ?>" class="edit-btn">
                            <span class="dashicons dashicons-edit"></span>
                        </a>
                        <a href="?page=smecon-settings&pg=services&del=<?php echo $index; ?>" class="_del_href delete-btn">
                            <span class="dashicons dashicons-trash"></span>
                        </a>
                    </td>
                </tr>
            <?php endforeach;
        else : ?>
            <tr>
                <td colspan="3">No services found.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<style>
    .dg-btn {
        border: 1px solid whitesmoke;
        transition: all 0.5s ease-in-out;
        padding: 8px 20px;
        background-color: #e28413;
        color: white;
        border-radius: 4px;
        font-weight: 600;
    }

    .dg-btn:hover {
        background-color: whitesmoke;
        color: black;
    }

    .edit-btn {
        background-color: #007bff;
        padding: 5px 8px;
        border-radius: 4px;
        color: white;
        margin-right: 5px;
        text-decoration: none;
    }

    .delete-btn {
        background-color: #dc3545;
        padding: 5px 8px;
        border-radius: 4px;
        color: white;
        text-decoration: none;
    }

    .edit-btn:hover,
    .delete-btn:hover {
        opacity: 0.85;
    }

    .dg-table {
        width: 100%;
        border-collapse: collapse;
    }

    .dg-table th,
    .dg-table td {
        padding: 10px;
        border: 1px solid #ddd;
    }

    .dg-table thead {
        background-color: #f2f2f2;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const delLinks = document.querySelectorAll('._del_href');
        delLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm('Are you sure you want to delete this service?')) {
                    e.preventDefault();
                }
            });
        });
    });
</script>
