<script>
document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('userDetailModal');
    const overlay = document.getElementById('modalOverlay');
    const closeModal = document.getElementById('closeModal');
    const userDetailContent = document.getElementById('userDetailContent');

    document.querySelectorAll('.username').forEach(username => {
        username.addEventListener('click', function (event) {
            event.stopPropagation(); // Prevent triggering row click event if any
            const row = username.closest('tr');
            const cells = row.querySelectorAll('td');
            const userDetails = `
                <p><strong>Gender:</strong> ${cells[2].innerText}</p>
                <p><strong>Location:</strong> ${cells[3].innerText}</p>
                <p><strong># of Websites:</strong> ${cells[4].innerText}</p>
                <p><strong># of Tools:</strong> ${cells[5].innerText}</p>
            `;
            modal.style.display = 'block';
            overlay.style.display = 'block';
            document.getElementById("userName").innerText = cells[1].innerText;
            document.getElementById("userSr").innerText = cells[0].innerText;
            document.getElementById("other-details").innerHTML = userDetails;
        });
    });

    closeModal.addEventListener('click', function () {
        modal.style.display = 'none';
        overlay.style.display = 'none';
    });

    overlay.addEventListener('click', function () {
        modal.style.display = 'none';
        overlay.style.display = 'none';
    });

    document.querySelectorAll(".delete-btn").forEach(function(btn) {
        btn.addEventListener('click', function(event) {
            event.preventDefault();
            var href = this.getAttribute("href");
            _popup({
                title:"Confirmatin",
                content:"Do you want to delete user?",
                btnOk:"YES",
                btnCancel:"NO",
                color : "red",
                action : href
            })
        });
    });
    document.querySelectorAll(".unverified").forEach(function(btn) {
        btn.addEventListener('click', function(event) {
            event.preventDefault();
            var href = this.getAttribute("href");
            _popup({
                title:"Unverification",
                content:"Do you want to unverify user?",
                btnOk:"YES",
                btnCancel:"NO",
                color : "orange",
                action : href
            })
        });
    });
    document.querySelectorAll(".verified").forEach(function(btn) {
        btn.addEventListener('click', function(event) {
            event.preventDefault();
            var href = this.getAttribute("href");
            _popup({
                title:"Unverification",
                content:"Do you want to verify user?",
                btnOk:"VERIFY",
                btnCancel:"NO",
                color : "green",
                action : href
            })
        });
    });
    document.querySelectorAll(".banned").forEach(function(btn) {
        btn.addEventListener('click', function(event) {
            event.preventDefault();
            var href = this.getAttribute("href");
            _popup({
                title:"Unverification",
                content:"Do you want to verify user?",
                btnOk:"BAN USER",
                btnCancel:"CANCEL",
                color : "grey",
                action : href
            })
        });
    });
    document.querySelectorAll(".unbanned").forEach(function(btn) {
        btn.addEventListener('click', function(event) {
            event.preventDefault();
            var href = this.getAttribute("href");
            _popup({
                title:"Unverification",
                content:"Do you want to verify user?",
                btnOk:"UN-BAN USER",
                btnCancel:"CANCEL",
                color : "green",
                action : href
            })
        });
    });

});
    document.addEventListener('DOMContentLoaded', function () {
        const table = document.querySelector('.theme_form .tbl');
        const headers = table.querySelectorAll('th');
        const tbody = table.querySelector('tbody');

        const getCellValue = (row, index) =>
            row.children[index].innerText || row.children[index].textContent;

        const comparer = (index, asc) => (a, b) => {
            const v1 = getCellValue(a, index);
            const v2 = getCellValue(b, index);
            const num1 = parseFloat(v1);
            const num2 = parseFloat(v2);
            if (!isNaN(num1) && !isNaN(num2)) {
                return (num1 - num2) * (asc ? 1 : -1);
            }
            return v1.toString().localeCompare(v2) * (asc ? 1 : -1);
        };

        headers.forEach((header, index) => {
            let asc = true;
            header.addEventListener('click', function () {
                // Reset all headers (remove arrows)
                headers.forEach(h => {
                    const text = h.getAttribute('data-original-text');
                    h.innerHTML = text;
                });

                // Sort table rows
                const rows = Array.from(tbody.querySelectorAll('tr'));
                rows.sort(comparer(index, asc));
                rows.forEach(row => tbody.appendChild(row));

                // Add arrow to clicked header
                const arrow = asc ? ' ▲' : ' ▼';
                header.innerHTML = header.getAttribute('data-original-text') + arrow;

                // Toggle direction
                asc = !asc;
            });

            // Store original header text to avoid icon duplication
            header.setAttribute('data-original-text', header.innerText.trim());
        });
    });
</script>