<?php
function def_bg(){
    return ADMIN_ASSET_URI."img/trans.png";
}

function dgaps_enqueue_metabox_script(){
    if ( ! did_action( 'wp_enqueue_media' ) ) {
      wp_enqueue_media();
    }

    $url = get_template_directory_uri();
    $url.= "/admin/assets/js/cmn.js?v=3";
    wp_enqueue_script('cmn-js', $url, array( 'jquery' ) , 1.0);    
}
add_action('admin_enqueue_scripts', 'dgaps_enqueue_metabox_script');


function lga_add_admin_menu_page() {
    add_menu_page(
        'SmeCon Settings',             // Page title
        'Smecon Admin',                // Menu title
        'manage_options',              // Capability
        'smecon-settings',          // Menu slug
        'lga_admin_page_callback',     // Callback function
        'dashicons-admin-tools',       // Icon
        2                              // Position
    );
}

add_action('admin_menu', 'lga_add_admin_menu_page');

function lga_admin_page_callback() {
    include_once THEME_DIR . '/admin/pages.php';
}

function lga_get_sm($type){
    if ($type=="youtube"){
        $f = get_option("lga_sm_".$type, []);
    }elseif ($type=="facebook"){
        $f = get_option("lga_sm_".$type, []);
    }else{
        $f = get_option("lga_sm_".$type, [
            "title" => "",
            "link" => "",
            "number" => "",
            "desp" => "",
            "logo" => get_template_directory_uri()."/assets/images/trans.png",
            "image" => 0,
            "button" => ""
        ]);
    }
    return $f;
}
function lga_set_block_list_template($item){
    ?>
    <?php if ($item["title"]!=""): ?>
    <tr>
        <td style="text-align:center;font-weight:bold;"><?php echo $item["n"]; ?></td>
        <td>
            <?php echo $item["title"]; ?>
        </td>
        <td style="text-align:center;">
            <template><?php echo json_encode($item); ?></template>
            <a href='#' class="_edit_sc_btn" data-id="<?php echo $item["id"]; ?>" data-modal="script-popup" style="color:green;" title="Edit Data">
                <span class="dashicons dashicons-edit"></span>
            </a> &nbsp;
            <a href='#' class="_del_sc_btn" data-id="<?php echo $item["id"]; ?>"  style="color:red;" title="Delete Data ">
                <span class="dashicons dashicons-trash"></span>
            </a>
        </td>
    </tr>
    <?php endif; ?>
    <?php
}

function save_lga_sm_data(){
    if ($_POST["title"] == "" || $_POST["link"]=="" || $_POST["number"]==""){
        echo "Please fill the fields!";
    }else{
        $type = $_POST["type"];
        $id = trim($_POST["id"]);
        unset($_POST["type"]);
        unset($_POST["id"]);
        $_POST["image"] = $_POST["logo"];
        $_POST["slug"] = sanitize_title($_POST["slug"]);
        $_POST["logo"] = wp_get_attachment_url($_POST["logo"]);
        $data = array();
        $d = lga_get_sm($type);
        if (is_array($data) and isset($d["title"])){
            $data[] = $d;
        }else{
            $data = $d;
        }
        if ($id!="" || $id!="undefined"){
            $data[$id] = $_POST;
        }else{
            $data[] = $_POST;    
        }
        $r_data = array();
        foreach($data as $k=>$item){
            $item["id"] = $k;
            $r_data[] = $item;
        }
        $type = "lga_sm_".$type;
        update_option($type, $r_data);
        $n = 1;
        foreach($r_data as $k=>$item){

            $item["n"] = $n;
            $n = $n + 1;
            lga_set_block_list_template($item);
        }
    }
    die();
}
add_action("wp_ajax_save_lga_sm_data", "save_lga_sm_data");
add_action("wp_ajax_nopriv_save_lga_sm_data", "save_lga_sm_data");

function delete_lga_sm_data(){
    $id = $_POST["id"];
    $type = $_POST["type"];
    $dt = lga_get_sm($type);
    $data  = array();
    foreach($dt as $k=>$v){
        if ($k == $id){
            
        }else{
            $data[] = $v;
        }
    }
    $type = "lga_sm_".$type;
    update_option($type, $data);
    echo "Deleted";
    die();
}
add_action("wp_ajax_delete_lga_sm_data", "delete_lga_sm_data");
add_action("wp_ajax_nopriv_delete_lga_sm_data", "delete_lga_sm_data");
function lga_get_sm_ajax(){
    $type = "lga_sm_".$_GET["g"];
    $g = $_GET["g"];
    $def[] = [
        "title" => "",
        "link" => "",
        "number" => "",
        "desp" => "",
        "logo" => get_template_directory_uri()."/assets/images/trans.png",
        "image" => 0,
        "button" => ""
    ];
    $f = get_option($type, $def);
    $f = (isset($f["title"])) ? [$f] : $f;
    $mf = array();
    foreach($f as $k=>$v){
        $mf[] = $v;
    }
    echo json_encode($mf);
    die();

}
add_action("wp_ajax_lga_get_sm_ajax", "lga_get_sm_ajax");
add_action("wp_ajax_nopriv_lga_get_sm_ajax", "lga_get_sm_ajax");

function inline_custom_admin_script() {?>
    <script type="text/javascript">
        let LGA_THME_URL = "<?php echo get_template_directory_uri(); ?>";
    </script>
    <?php
}
add_action('admin_head', 'inline_custom_admin_script');