<?php
ob_start();
define("THEME_URI", get_template_directory_uri());
define("THEME_DIR", get_template_directory());
define("THEME_NAME", "lga-web-tools");
define("THEME_VERSION", "1.0.0");
define("ASSETS_DIR", THEME_DIR . "/assets/");
define("ASSETS_URI", THEME_URI . "/assets/");
define("CSS_DIR", ASSETS_DIR . "css/");
define("CSS_URI", ASSETS_URI . "css/");
define("JS_DIR", ASSETS_DIR . "js/");
define("JS_URI", ASSETS_URI . "js/");
define("IMAGES_DIR", ASSETS_DIR . "images/");
define("IMAGES_URI", ASSETS_URI . "images/");
define("ADMIN_URI", THEME_URI . "/admin/");
define("ADMIN_ASSET_URI", ADMIN_URI . "assets/");

add_theme_support('post-thumbnails');


$upload_dir = wp_upload_dir();


function smecon_register_menus()
{
    register_nav_menus(
        array(
            'primary' => __('Primary Menu', 'smecon'),
            'footer' => __('Footer Menu', 'smecon'),
            'social' => __('Social Menu', 'smecon'),
        )
    );
}
add_action('init', 'smecon_register_menus');

function netracontech_theme_setup() {
    add_theme_support('custom-logo', array(
        'height'      => 100,
        'width'       => 300,
        'flex-height' => true,
        'flex-width'  => true,
    ));
}
add_action('after_setup_theme', 'netracontech_theme_setup');


// Register Footer Menus
function register_footer_menus() {
    register_nav_menus(array(
        'footer-col-1' => __('Footer Column 1'),
        'footer-col-2' => __('Footer Column 2'),
        'footer-col-3' => __('Footer Column 3'),
        'footer-col-4' => __('Footer Column 4'),
    ));
}
add_action('after_setup_theme', 'register_footer_menus');

// Add slider settings to admin
function lga_add_slider_settings_page() {
    add_menu_page(
        'Slider Settings',
        'Slider Settings',
        'manage_options',
        'lga-slider-settings',
        'lga_slider_settings_page',
        'dashicons-images-alt2',
        100
    );
}
add_action('admin_menu', 'lga_add_slider_settings_page');

// Callback for slider page
function lga_slider_settings_page() {
    include get_template_directory() . '/admin/slider-settings.php';
}
if (!function_exists('extract_youtube_id')) {
    function extract_youtube_id($url) {
        // Handles both full URLs and shortened YouTube links
        parse_str(parse_url($url, PHP_URL_QUERY), $vars);
        if (isset($vars['v'])) return $vars['v'];

        if (preg_match('/youtu\.be\/([^\?&]+)/', $url, $matches)) return $matches[1];

        if (preg_match('/\/embed\/([^\?&]+)/', $url, $matches)) return $matches[1];

        return false;
    }
}

// Enqueue media uploader
function lga_slider_admin_scripts($hook) {
    if ($hook !== 'toplevel_page_lga-slider-settings') return;
    wp_enqueue_media();
    wp_enqueue_script('lga-slider-js', get_template_directory_uri() . '/admin/assets/slider.js', ['jquery'], null, true);
}
add_action('admin_enqueue_scripts', 'lga_slider_admin_scripts');




//Start Tool Rule
function register_project_rewrite_rule() {
    add_rewrite_rule(
        '^project/([^/]+)/?',
        'index.php?project_page=$matches[1]',
        'top'
    );
}
add_action('init', 'register_project_rewrite_rule');

function add_project_query_var($vars) {
    $vars[] = 'project_page';
    return $vars;
}
add_filter('query_vars', 'add_project_query_var');

function flush_rewrite_on_activation() {
    register_project_rewrite_rule(); // register rule before flushing
    flush_rewrite_rules();
}
add_action('after_switch_theme', 'flush_rewrite_on_activation');

add_action('template_redirect', 'load_custom_tool_template');
function load_custom_tool_template() {
    $tool_page = get_query_var('project_page');
    if ($tool_page) {
        include get_template_directory() . '/single-project.php';
        exit;
    }
}
//End Tool Rule
add_action('wp_ajax_load_more_blogs', 'load_more_blogs_ajax_handler');
add_action('wp_ajax_nopriv_load_more_blogs', 'load_more_blogs_ajax_handler');

function load_more_blogs_ajax_handler() {
    $paged = isset($_GET['page']) ? intval($_GET['page']) : 1;

    $query = new WP_Query([
        'post_type' => 'post',
        'posts_per_page' => 3,
        'paged' => $paged,
    ]);

    if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post(); ?>
            <div class="col-lg-4 col-md-6 col-sm-12 mb-4 blog-item">
                <a href="<?php the_permalink(); ?>">
                    <div class="blog-box">
                        <div class="img">
                            <?php if (has_post_thumbnail()) :
                                the_post_thumbnail('medium');
                            else : ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default.jpg" alt="Default image">
                            <?php endif; ?>
                            <div class="bol"><?php echo get_the_date('d M'); ?></div>
                        </div>
                        <h3 class="blog-title"><?php the_title(); ?></h3>
                        <p class="blog-description"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    </div>
                </a>
            </div>
        <?php endwhile;
    endif;
    wp_reset_postdata();
    die();
}

// Start Service Rule
function register_service_rewrite_rule() {
    add_rewrite_rule(
        '^service/([^/]+)/?',
        'index.php?service_page=$matches[1]',
        'top'
    );
}
add_action('init', 'register_service_rewrite_rule');

function add_service_query_var($vars) {
    $vars[] = 'service_page';
    return $vars;
}
add_filter('query_vars', 'add_service_query_var');

function flush_service_rewrite_on_activation() {
    register_service_rewrite_rule(); // register before flush
    flush_rewrite_rules();
}
add_action('after_switch_theme', 'flush_service_rewrite_on_activation');

add_action('template_redirect', 'load_custom_service_template');
function load_custom_service_template() {
    $service_page = get_query_var('service_page');
    if ($service_page) {
        include get_template_directory() . '/single-services.php';
        exit;
    }
}


add_action('save_post', 'save_project_design_files');
function save_project_design_files($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (!isset($_POST['design_files'])) return;

    $design_files = [];
    
    foreach ($_POST['design_files'] as $index => $data) {
        $name = sanitize_text_field($data['name']);
        $url  = isset($data['url']) ? esc_url_raw($data['url']) : '';

        // Check if new file uploaded
        if (isset($_FILES['design_files']['name'][$index]['file']) && !empty($_FILES['design_files']['name'][$index]['file'])) {
            $file = [
                'name'     => $_FILES['design_files']['name'][$index]['file'],
                'type'     => $_FILES['design_files']['type'][$index]['file'],
                'tmp_name' => $_FILES['design_files']['tmp_name'][$index]['file'],
                'error'    => $_FILES['design_files']['error'][$index]['file'],
                'size'     => $_FILES['design_files']['size'][$index]['file'],
            ];

            // Upload the file
            $upload = wp_handle_upload($file, ['test_form' => false]);

            if (!isset($upload['error'])) {
                $url = $upload['url'];
            }
        }

        // Save both name and url
        $design_files[] = [
            'name' => $name,
            'url'  => $url,
        ];
    }

    update_post_meta($post_id, 'project_design_files', $design_files);
}

add_action('save_post', 'save_project_slider');
function save_project_slider($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (!isset($_POST['project_slider']) || !is_array($_POST['project_slider'])) return;

    // Validate and sanitize each slider image ID
    foreach ($_POST['project_slider'] as $key => $img_id) {
        $_POST['project_slider'][$key] = intval($img_id);
    }

    // Filter out empty values
    $filtered_slider = array_filter($_POST['project_slider'], function($val){
        return !empty($val);
    });
    update_post_meta($post_id, 'project_slider', $filtered_slider);
}


// Usage: [project_slider id="148"]

function render_project_slider_shortcode($atts) {
    $atts = shortcode_atts([
        'id' => 0,
    ], $atts);

    $post_id = intval($atts['id']);
    if (!$post_id) return 'Invalid project ID.';

    $project_slider = get_post_meta($post_id, 'project_slider', true);
    if (!is_array($project_slider) || empty($project_slider)) {
        return '<p>No project images found.</p>';
    }

    ob_start();
    ?>
    <div id="project-slider" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            <?php foreach ($project_slider as $index => $img_id): ?>
                <?php $img_url = wp_get_attachment_url($img_id); ?>
                <div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>">
                    <img src="<?php echo esc_url($img_url); ?>" alt="Slide <?php echo $index + 1; ?>">
                </div>
            <?php endforeach; ?>
        </div>
        <a class="carousel-control-prev" href="#project-slider" role="button" data-slide="prev">
            <i class="fas fa-chevron-left"></i>
        </a>
        <a class="carousel-control-next" href="#project-slider" role="button" data-slide="next">
            <i class="fas fa-chevron-right"></i>
        </a>
        <ol class="carousel-indicators">
            <?php foreach ($project_slider as $index => $img_id): ?>
                <li data-target="#project-slider" data-slide-to="<?php echo $index; ?>" class="<?php echo $index === 0 ? 'active' : ''; ?>"></li>
            <?php endforeach; ?>
        </ol>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('project_slider', 'render_project_slider_shortcode');






include "admin/set.php";