<?php include "header.php"; ?>
<style>
.first,.last{padding:20px;border-top:3px solid var(--site-color);background-color:#fff;box-shadow:0 4px 12px rgba(0,0,0,.1)}.collig,.hidden-data,.input-box label,.sec2addr p span{font-weight:700}.sec2contactform h2{font-size:2rem}.first{border-radius:10px}.form-con{margin:2rem auto}:root{--text-color:#333;--bg-light:#f9f9f9;--border-radius:5px}.textcenter h1{font-size:36px;color:var(--site-color);margin-bottom:20px}.section2{display:flex;flex-wrap:wrap;gap:20px}.col2{width:70%}.column2{width:25%;display:flex;flex-direction:column;align-items:center}.sec2innercont img{width:100%;border-radius:var(--border-radius);margin-bottom:20px}.full-width,.sec2contactform{width:100%}.form-group{display:flex;gap:10px;margin-bottom:2rem}.input-box{width:50%;display:flex;flex-direction:column}.input-box label{font-size:14px;margin-bottom:10px;color:var(--site-color)}.sec2contactform input,.sec2contactform textarea{width:100%;padding:12px;border:1px solid #ccc;border-radius:var(--border-radius);font-size:16px}.sec2contactform textarea{resize:none;height:120px}.sec2contactform button{width:100%;padding:12px;background:var(--site-color);color:#fff;font-size:18px;border:none;border-radius:var(--border-radius);cursor:pointer;transition:background .3s}.sec2contactform button:hover{background:#c96c0d}.sec2addr{margin:20px 0}.sec2addr p{margin-bottom:10px;color:var(--text-color);font-size:16px;font-weight:500;color:#444}.map-section{margin-top:30px;padding:0}.map-section iframe{margin:0;padding:0;width:100%;height:50vh}.sec2contactform form{background:#f8f9fa;padding:20px;border-radius:10px;box-shadow:0 4px 10px rgba(0,0,0,.1)}.input-box input,.input-box textarea{width:100%;padding:10px;border:1px solid #ddd;border-radius:5px;transition:.3s}.input-box input:focus,.input-box textarea:focus{border-color:var(--site-color);box-shadow:0 0 5px var(--site-color)}button{background:linear-gradient(45deg,var(--site-color),#0056b3);color:#fff;padding:12px 20px;border:none;border-radius:5px;font-size:16px;cursor:pointer;transition:transform .3s,background .3s}button:hover{background:linear-gradient(45deg,#0056b3,#003f7f)}.tm-widget-social-list li a{display:flex;align-items:center;justify-content:center;width:40px;height:40px;font-size:20px;border-radius:50%;transition:.3s ease-in-out}.tm-widget-social-list li a:hover{transform:scale(1.2)}.hidden-data{position:relative;color:#333;transition:color .3s ease-in-out;cursor:pointer;user-select:none}.hidden-data:hover::after{content:attr(data-full);top:-30px;left:0;font-size:12px;opacity:0;transition:opacity .3s,transform .3s;opacity:1;transform:translateY(0);content:attr(data-full);position:absolute;background:#fff;padding:5px 10px;border-radius:5px;box-shadow:0 0 10px rgba(0,0,0,.1);color:#333;font-weight:700;white-space:nowrap;z-index:10;content:none}.last{border-radius:12px;transition:.3s ease-in-out}.info-box{background:#fff;padding:15px;border-radius:10px;box-shadow:0 4px 8px rgba(0,0,0,.08)}.contact-img{max-width:80px;border-radius:50%;margin-bottom:10px}.collig{color:var(--site-color)}.social-icons ul{display:flex;justify-content:center;gap:10px;padding:0;margin-top:10px}.social-icons li{list-style:none}.social-icons a{display:flex;align-items:center;justify-content:center;width:40px;height:40px;font-size:18px;color:#fff;border-radius:50%;transition:.3s}.social-icons .facebook{background:#3b5998}.social-icons .email{background:#787482}.social-icons .instagram{background:#e2002b}.social-icons .linkedin{background:#007bb6}.social-icons .youtube{background:#c71f1e}.social-icons a:hover{transform:scale(1.2);opacity:.8}@media (max-width:960px){.col2,.column2,.input-box{width:100%}.form-group{flex-direction:column}}@media (max-width:500px){.sec2contactform h2{font-size:1.5rem}}
</style>


<?php
$options = get_option("lga_tools_contact");
$contact_title = esc_html($options['home_page_title'] ?? 'Contact Us');
$phone1 = esc_html($options['phone1'] ?? '');
$phone2 = esc_html($options['phone2'] ?? '');
$email = esc_html($options['email'] ?? '');
$location = esc_html($options['location'] ?? '');
$website = esc_url($options['website'] ?? '');
$map = $options['map'] ?? ''; // raw iframe embed
?>

<div class="main-content">

    <section class="page-title tbb tm-page-title text-left flip text-default page-title-split" style=" background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/contactbanner.webp); ">
        <div class="container padding-extra-large">
            <div class="row">
                <div class="col-md-7 sm-text-center title-content">
                    <h1 class="title"><?php echo $contact_title; ?></h1>
                </div>
                <div class="col-md-5 text-right flip sm-text-center"></div>
            </div>
        </div>
    </section>

    <div class="form-con container">
        <div class="innerwrap">

            <section class="section2 clearfix">
                <div class="col2 column1 first">
                    <div class="sec2contactform">
                        <h2 class="sec2frmtitle">Want to Know More? Drop Us a Mail</h2>
                        <hr>
                        <form action="">
                            <div class="form-group">
                                <div class="input-box">
                                    <label for="fname">First Name</label>
                                    <input id="fname" type="text" placeholder="First Name">
                                </div>
                                <div class="input-box">
                                    <label for="lname">Last Name</label>
                                    <input id="lname" type="text" placeholder="Last Name">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="input-box">
                                    <label for="email">Email</label>
                                    <input id="email" type="email" placeholder="Email">
                                </div>
                                <div class="input-box">
                                    <label for="contact">Contact Number</label>
                                    <input id="contact" type="text" placeholder="Contact Number">
                                </div>
                            </div>

                            <div class="form-group full-width">
                                <!-- <label for="message">Your Message</label><br><br> -->
                                <textarea id="message" cols="30" rows="5" placeholder="Your message here..."></textarea>
                            </div>

                            <div class="form-group full-width">
                                <button type="submit">Send Message</button>
                            </div>
                        </form>
                    </div>
                </div>



                <div class="col2 column2 last">
                    <div class="sec2innercont">
                        <h4>Information</h4>
                        <hr>
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/contactus.webp" alt="Contact Image">
                        <div class="sec2addr info-box">
                            <p>
                                <span class="collig">Address: </span><?php echo $location; ?>
                            </p>
                            <?php if (!empty($phone1)): ?>
                                <p>
                                    <span class="collig">Phone 1: </span>
                                    <span class="hidden-data" data-full="<?php echo $phone1; ?>" data-hidden="<?php echo substr($phone1, 0, 4) . ' *** ****' . substr($phone1, -2); ?>" onclick="toggleData(this)">
                                        <?php echo substr($phone1, 0, 4) . ' *** ****' . substr($phone1, -2); ?>
                                    </span>
                                </p>
                            <?php endif; ?>

                            <?php if (!empty($phone2)): ?>
                                <p>
                                    <span class="collig">Phone 2: </span>
                                    <span class="hidden-data" data-full="<?php echo $phone2; ?>" data-hidden="<?php echo substr($phone2, 0, 4) . ' *** ****' . substr($phone2, -2); ?>" onclick="toggleData(this)">
                                        <?php echo substr($phone2, 0, 4) . ' *** ****' . substr($phone2, -2); ?>
                                    </span>
                                </p>
                            <?php endif; ?>

                            <?php if (!empty($email)): ?>
                                <p>
                                    <span class="collig">Email: </span>
                                    <span class="hidden-data" data-full="<?php echo $email; ?>" data-hidden="<?php echo substr($email, 0, 2) . '*****@***'; ?>" onclick="toggleData(this)">
                                        <?php echo substr($email, 0, 2) . '*****@***'; ?>
                                    </span>
                                </p>
                            <?php endif; ?>

                            <script>
                                function toggleData(element) {
                                    let fullData = element.getAttribute('data-full');
                                    let hiddenData = element.getAttribute('data-hidden');

                                    if (element.innerText === hiddenData) {
                                        element.innerText = fullData;
                                    } else {
                                        element.innerText = hiddenData; // Toggle back if clicked again
                                    }
                                }
                            </script>

                        </div>
                        <?php
                        $facebook  = !empty($settings['facebook']) ? $settings['facebook'] : '#';
                        $instagram = !empty($settings['instagram']) ? $settings['instagram'] : '#';
                        $linkedin  = !empty($settings['linkedin']) ? $settings['linkedin'] : '#';
                        $youtube   = !empty($settings['youtube']) ? $settings['youtube'] : '#';
                        ?>


                        <div id="tm_widget_social_list-1" class="widge widget-social-icons clearfix">
                            <ul class="tm-widget tm-widget-social-list tm-widget-social-list-brand styled-icons styled-icons-brand icon-rounded">
                                <?php if ($facebook): ?>
                                    <li>
                                        <a class="social-link styled-icons-item" data-tm-bg-color="#3B5998" href="<?php echo esc_url($facebook); ?>" target="_blank" style="background: #3B5998;">
                                            <i class="fa-brands fa-facebook"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if ($instagram): ?>
                                    <li>
                                        <a class="social-link styled-icons-item" data-tm-bg-color="#E2002B" href="<?php echo esc_url($instagram); ?>" target="_blank" style="background: #E2002B;">
                                            <i class="fa-brands fa-instagram"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if ($linkedin): ?>
                                    <li>
                                        <a class="social-link styled-icons-item" data-tm-bg-color="#007BB6" href="<?php echo esc_url($linkedin); ?>" target="_blank" style="background: #007BB6;">
                                            <i class="fa-brands fa-linkedin"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php if ($youtube): ?>
                                    <li>
                                        <a class="social-link styled-icons-item" data-tm-bg-color="#C71F1E" href="<?php echo esc_url($youtube); ?>" target="_blank" style="background: #C71F1E;">
                                            <i class="fa-brands fa-youtube"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>

                    </div>
                </div>
            </section>
        </div>
    </div>


    <section class="map-section container-fluid">
            <iframe class="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3321.683680092866!2d72.91213441513443!3d33.6394428807203!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x38df97c22dd956e9%3A0x29c54dbd9440c13f!2sSmecon%20(Pvt)%20Limited!5e0!3m2!1sen!2s!4v1652343545315!5m2!1sen!2s" allowfullscreen="" loading="lazy"></iframe>
        </section>



</div>



<?php include "footer.php"; ?>