<?php include "header.php"; ?>
<style>
    .tm-section {
        padding-top: 50px;
    }

    .tm-text-box {
        padding: 30px;
        background: #f9f9f9;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .tm-text-box h2 {
        margin-top: 0;
        font-size: 30px;
        color: var(--site-color);
    }

    .tm-text-box p {
        margin: 0 0 20px;
        font-size: 16px;
        line-height: 1.6;
    }

    .tm-text-box ul {
        margin: 0 0 20px;
    }

    .tm-text-box ul li {
        margin: 0 0 10px;
        font-size: 16px;
        line-height: 1.6;
        background: white;
        padding: 10px;
        list-style-type: none;
        border-radius: 10px;
    }

    .tm-text-box ul li:before {
        content: "\f00c";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        margin-right: 10px;
        color: var(--site-color);
    }

    .tm-text-box img {
        margin-bottom: 20px;
        border-radius: 10px;
    }

    .tm-gallery {
        text-align: center;
        margin-top: 50px;
    }

    .tm-gallery-item {
        position: relative;
        margin-bottom: 30px;
        overflow: hidden;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }


    .tm-gallery-item img {
        width: 100%;
        height: auto;
        border-radius: 10px;
        transition: transform 0.3s ease;
        aspect-ratio: 3/2;
    }

    .tm-gallery-item:hover img {
        transform: scale(1.1) rotate(1deg);
        cursor: pointer;
    }


    .tm-gallery-item-info {
        position: absolute;
        bottom: 10px;
        left: 10px;
        background: rgba(0, 0, 0, 0.9);
        color: #fff;
        padding: 10px;
        border-radius: 5px;
        text-align: left;
    }

    .tm-gallery-item-info h3 {
        margin: 0;
        font-size: 18px;
        color: var(--site-color);
    }

    .tm-gallery-item-info p {
        margin: 5px 0 0;
        font-size: 13px;
        font-family: cursive;
    }

    .tools {
        /* padding: 3rem 0; */
        background: linear-gradient(135deg, #fff 21px, rgba(236, 236, 236, 0.62) 22px, rgba(236, 236, 236, 0.62) 24px, transparent 24px, transparent 67px, rgba(236, 236, 236, 0.62) 67px, rgba(236, 236, 236, 0.62) 69px, transparent 69px), linear-gradient(225deg, #fff 21px, rgba(236, 236, 236, 0.62) 22px, rgba(236, 236, 236, 0.62) 24px, transparent 24px, transparent 67px, rgba(236, 236, 236, 0.62) 67px, rgba(236, 236, 236, 0.62) 69px, transparent 69px) 0 64px;
        background-color: #fff;
        background-size: 64px 128px;
    }

    @media (max-width: 767px) {
        .tm-text-box h2 {
            font-size: 24px;
        }

        .tm-text-box p {
            font-size: 14px;
        }

        .tm-text-box ul li {
            font-size: 14px;
        }

        .tm-gallery-item-info h3 {
            font-size: 16px;
        }

        .tm-gallery-item-info p {
            font-size: 12px;
        }
    }
</style>
<?php
$health_data = get_option('health_safety_data');
if (!empty($health_data)) :
    $banner_title    = esc_html($health_data['health_banner_title'] ?? '');
    $section_title   = esc_html($health_data['health_section_title'] ?? '');
    $section_content = wp_kses_post($health_data['health_description'] ?? '');
?>

    <div class="main-content">

        <section class="page-title tbb tm-page-title text-left flip text-default page-title-split" style=" background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/contactbanner.webp)">
            <div class="container padding-extra-large">
                <div class="row">
                    <div class="col-md-7sm-text-center title-content">
                        <h1 class="title"><?php echo $banner_title; ?></h1>
                    </div>
                </div>
            </div>
        </section>




        <section class="tm-section mb-5">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="tm-text-box text-left pt-5">

                            <?php if ($section_title): ?>
                                <h2><?php echo $section_title; ?></h2>
                            <?php endif; ?>

                            <?php if ($section_content): ?>
                                <div class="health-description">
                                    <?php echo $section_content; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php endif; ?>



    <section class="tm-section tools">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="tm-gallery">
                        <h2 class="mb-5">Tools For Health & Safety</h2>
                        <div class="row">
                            <?php
                            $health_data = get_option('health_safety_data');
                            $tools = $health_data['tools'] ?? [];

                            if (!empty($tools)) :
                                foreach ($tools as $tool) :
                                    $tool_name = esc_html($tool['name'] ?? '');
                                    $tool_description = esc_html($tool['description'] ?? '');
                                    $banner_id = intval($tool['banner'] ?? 0);
                                    $banner_url = $banner_id ? wp_get_attachment_url($banner_id) : get_template_directory_uri() . '/assets/images/placeholder.png';
                            ?>
                                    <div class="col-md-4">
                                        <div class="tm-gallery-item">
                                            <img src="<?php echo esc_url($banner_url); ?>" alt="<?php echo esc_attr($tool_name); ?>" class="img-responsive">
                                            <div class="tm-gallery-item-info">
                                                <h3><?php echo $tool_name; ?></h3>
                                                <p><?php echo $tool_description; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php
                                endforeach;
                            else :
                                ?>
                                <p class="text-muted">No tools available at the moment.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    </div>


    <?php include "footer.php"; ?>