<?php include "header.php"; ?>

<style>
    .img-fluid {
        width: 100%;
    }

    .custom-card {
        border: none;
        overflow: hidden;
        /* box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); */
        transition: transform 0.3s ease-in-out;
        border-radius: 0px 10px 10px 0px
    }

    .custom-card img {
        height: 100%;
        object-fit: cover;
        border-radius: 10px;
    }

    .custom-card .card-body {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        height: 100%;
        overflow: hidden;
    }

    .custom-card .btn-primary {
        width: max-content;
        padding: 10px 20px;
        background-color: var(--site-color);
    }

    .col-lg-12 {
        border-radius: 30px;
    }


    .card-body {
        position: relative;
        z-index: 999;
    }

    .card-body h3 {
        font-size: 2rem;
    }

    .project-status {
        position: absolute;
        top: -50px;
        right: -100px;
        width: 500px;
        height: 500px;
        background-color: var(--site-color);
        border-radius: 50%;
        opacity: 0.1;
        z-index: -1;
    }

    .project-status-2 {
        position: absolute;
        top: -50px;
        left: -100px;
        width: 500px;
        height: 500px;
        background-color: var(--site-color);
        border-radius: 50%;
        opacity: 0.1;
        z-index: -1;
    }

    .project-image {
        position: relative;
    }

    .black {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
        border-radius: 10px;
        border: 5px solid var(--site-color);
    }

    .pr-st {
        position: absolute;
        top: 0%;
        background-color: var(--site-color);
        color: white;
        padding: 10px 20px;
        border-radius: 10px 10px 0px 0px;
        font-weight: bold;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        letter-spacing: 1px;
        width: 100%;
    }

    .pr-st p {
        margin: 0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 1rem;
    }

    .status {
        background-color: white;
        color: var(--site-color);
        padding: 2px 15px;
        border-radius: 5px;
        font-weight: bold;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

    .card-text {
        padding-left: 20px;
    }

    .card-text ul {
        list-style: none;
        padding: 0;
        margin-bottom: 10px;
    }

    .card-text ul li {
        line-height: 30px;
        font-size: 1rem;
    }

    .card-text ul li span {
        font-weight: bold;
        color: var(--site-color);
        font-family: monospace;
    }

    .card-text ul li span i {
        margin-right: 5px;
        color: #002c42;
    }


    .nav-tabs .nav-item.show .nav-link,
    .nav-tabs .nav-link.active {
        color: #fff;
        background-color: var(--site-color);
        border-color: #dee2e6 #dee2e6 #fff;
    }

    .nav-tabs .nav-link {
        border: 1px solid transparent;
        border-top-left-radius: .25rem;
        border-top-right-radius: .25rem;
    }

    @media (max-width: 500px) {
        .card-body h3 {
            font-size: 1.5rem;
            padding-left: 10px;
        }
    }
</style>

<div class="main-content">

    <section class="page-title tm-page-title text-left flip text-default page-title-split" style=" background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/pp.webp); ">
        <div class="container padding-extra-large">
            <div class="row">
                <div class="col-md-7sm-text-center title-content">
                    <h1 class="title">Our Projects</h1>
                </div>
            </div>
        </div>
    </section>

    <div class="container my-5">
        <ul class="nav nav-tabs" id="projectTabs" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" id="all-projects-tab" data-toggle="tab" href="#all-projects" role="tab" aria-controls="all-projects" aria-selected="true">All Projects</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" id="completed-projects-tab" data-toggle="tab" href="#completed-projects" role="tab" aria-controls="completed-projects" aria-selected="false">Completed</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" id="in-hand-projects-tab" data-toggle="tab" href="#in-hand-projects" role="tab" aria-controls="in-hand-projects" aria-selected="false">In Hand</a>
            </li>
        </ul>

        <?php
$all_projects = get_posts([
    'post_type' => 'project',
    'posts_per_page' => -1,
    'post_status' => 'publish',
]);

$completed_projects = array_filter($all_projects, function ($p) {
    $status = strtolower(get_post_meta($p->ID, 'project_status', true));
    return $status === 'completed';
});

$in_hand_projects = array_filter($all_projects, function ($p) {
    $status = strtolower(get_post_meta($p->ID, 'project_status', true));
    return $status === 'in-hand' || $status === 'in hand';
});
?>


        <div class="tab-content" id="projectTabsContent">

            <!-- All Projects Tab -->
            <div class="tab-pane fade show active" id="all-projects" role="tabpanel" aria-labelledby="all-projects-tab">
                <div class="container mt-2">
                    <div class="row justify-content-center">
                        <?php
                        if (!empty($all_projects)) :
                            foreach ($all_projects as $project) :
                                include 'project-card.php';
                            endforeach;
                        else :
                            echo '<p class="text-center">No projects available.</p>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>


            <!-- Completed Projects Tab -->
            <div class="tab-pane fade" id="completed-projects" role="tabpanel" aria-labelledby="completed-projects-tab">
                <div class="container mt-2">
                    <div class="row justify-content-center">
                        <?php
                        if (!empty($completed_projects)) :
                            foreach ($completed_projects as $project) :
                                include 'project-card.php';
                            endforeach;
                        else :
                            echo '<p class="text-center">No completed projects.</p>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>

            <!-- In Hand Projects Tab -->
            <div class="tab-pane fade" id="in-hand-projects" role="tabpanel" aria-labelledby="in-hand-projects-tab">
                <div class="container mt-2">
                    <div class="row justify-content-center">
                        <?php
                        if (!empty($in_hand_projects)) :
                            foreach ($in_hand_projects as $project) :
                                include 'project-card.php';
                            endforeach;
                        else :
                            echo '<p class="text-center">No in-hand projects.</p>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>

        </div>


    </div>



</div>
<!-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<?php include "footer.php"; ?>