<?php include "header.php"; ?>

<style>
    .img-fluid {
        width: 100%;
    }

    .custom-card {
        border: none;
        overflow: hidden;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease-in-out;
    }

    .custom-card img {
        height: 100%;
        object-fit: cover;
        border-radius: 10px;
    }

    .custom-card .card-body {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        height: 100%;
    }

    .custom-card .btn-primary {
        width: max-content;
        padding: 10px 20px;
        background-color: var(--site-color);
    }

    .col-lg-12 {
        border-radius: 30px;
    }


    .containe {
        max-width: 900px;
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
        grid-gap: 48px;
        margin: auto;
    }

    .card-service {
        cursor: pointer;
        position: relative;
        height: 0;
        padding-bottom: 120%;
        --offset-multiplier: 4px;
        transition: transform 0.6s ease;
        --translate: 0;
        transform: translate(var(--translate), var(--translate));
    }

    .card-service:hover {
        --offset-multiplier: 6px;
    }

    .card-service:hover {
        --translate: calc(-1px * (var(--cards) - 1));
        transition: transform 0.3s ease;
    }

    .child {
        position: absolute;
        width: 100%;
        height: 100%;
        padding: 0 16px;
        box-sizing: border-box;
        background: #fff;
        box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1), 0px -4px 8px rgba(255, 255, 255, 0.8);
        border-radius: 6px;
        transition: inherit;
        --translate: calc(var(--offset) * var(--offset-multiplier));
        transform: translate(var(--translate), var(--translate));
        z-index: 5;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .child:nth-child(1) {
        --offset: 0;
        z-index: 4;
    }

    .child:nth-child(2) {
        --offset: 1;
        z-index: 3;
    }

    .child:nth-child(3) {
        --offset: 2;
        z-index: 2;
    }

    .child:nth-child(4) {
        --offset: 3;
        z-index: 1;
    }

    .child:nth-child(5) {
        --offset: 4;
        z-index: 0;
    }


    .site-heading h2 {
        display: block;
        font-weight: 700;
        margin-bottom: 10px;
        text-transform: uppercase;
    }

    .site-heading h2 span {
        color: var(--site-color);
    }

    .site-heading h4 {
        display: inline-block;
        padding-bottom: 20px;
        margin: 0;
        position: relative;
        text-transform: capitalize;
        z-index: 1;
    }

    .site-heading h4::before {
        background: var(--site-color) none repeat scroll 0 0;
        bottom: 0;
        content: "";
        height: 2px;
        left: 50%;
        margin-left: -25px;
        position: absolute;
        width: 50px;
    }

    .site-heading {
        margin-bottom: 60px;
        overflow: hidden;
    }

    .serr {
        padding: 3rem 0;
        background: linear-gradient(135deg, #fff 21px, rgba(236, 236, 236, 0.62) 22px, rgba(236, 236, 236, 0.62) 24px, transparent 24px, transparent 67px, rgba(236, 236, 236, 0.62) 67px, rgba(236, 236, 236, 0.62) 69px, transparent 69px), linear-gradient(225deg, #fff 21px, rgba(236, 236, 236, 0.62) 22px, rgba(236, 236, 236, 0.62) 24px, transparent 24px, transparent 67px, rgba(236, 236, 236, 0.62) 67px, rgba(236, 236, 236, 0.62) 69px, transparent 69px) 0 64px;
        background-color: #fff;
        background-size: 64px 128px;
    }

    .ab-img img {
        margin: 3rem auto;
        filter: drop-shadow(2px 4px 6px var(--site-color));
        border-radius: 10px;
    }
</style>
<div class="main-content">

    <!-- Top Banner -->
    <section class="page-title tm-page-title text-left flip text-default page-title-split" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/ss.webp);">
        <div class="container padding-extra-large">
            <div class="row bread">
                <div class="col-md-7 sm-text-center title-content">
                    <h1 class="title">Our Services</h1>
                </div>
            </div>
        </div>
    </section>

    <!-- Top Image -->
    <div class="container">
        <div class="row">
            <div class="ab-img my-4">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/ourservise.webp" alt="Our Services Image" class="img-fluid">
            </div>
        </div>
    </div>

    <!-- Services List -->
    <div class="container my-5">
        <div class="row justify-content-center">
            <?php
            $services = get_option('services_data');
            if (!empty($services) && is_array($services)) :
                foreach ($services as $service) :
                    $title = esc_html($service['service_title'] ?? 'N/A');
                    $desc = esc_html($service['service_description'] ?? 'N/A');
                    $banner_id = intval($service['service_banner'] ?? 0);
                    $banner = $banner_id ? esc_url(wp_get_attachment_url($banner_id)) : get_template_directory_uri() . '/admin/assets/img/trans.png';
                    $slug = sanitize_title($service['service_title'] ?? '');
                    $detail_url = home_url('/service/' . $slug);
            ?>
                    <div class="col-lg-12 py-3">
                        <div class="card custom-card">
                            <div class="row g-0 align-items-center">
                                <div class="col-md-5">
                                    <img src="<?php echo $banner; ?>" class="img-fluid rounded-start" alt="Service Banner">
                                </div>
                                <div class="col-md-7 d-flex flex-column" style="background-color: antiquewhite;">
                                    <div class="card-body">
                                        <h3 class="card-title"><?php echo $title; ?></h3>
                                        <p class="card-text"><?php echo $desc; ?></p>
                                        <div class="btn-view-details">
                                            <a href="<?php echo esc_url($detail_url); ?>" class="btn btn-plain-text-with-arrow" style="float: right;">
                                                Read more
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php
                endforeach;
            else :
                echo '<div class="col-md-12 text-center"><p>No services found.</p></div>';
            endif;
            ?>
        </div>
    </div>

</div>

<?php include "footer.php"; ?>