<?php
$title = esc_html(get_the_title($project->ID));
$location = esc_html(get_post_meta($project->ID, 'project_location', true));
$employer = esc_html(get_post_meta($project->ID, 'project_employer', true));
$engineer = esc_html(get_post_meta($project->ID, 'project_engineer', true));
$completion_date = esc_html(get_post_meta($project->ID, 'project_completion_date', true));
$funding = esc_html(get_post_meta($project->ID, 'project_funding', true));
$status = esc_html(get_post_meta($project->ID, 'project_status', true));
$banner = wp_get_attachment_url(get_post_meta($project->ID, 'project_banner', true));
$slug = $project->post_name;
?>



<div class="col-lg-12 py-3">
    <div class="card custom-card" data-project-id="<?php echo $project_id; ?>">
        <div class="row g-0 align-items-center">
            <div class="col-md-5">
                <div class="project-image">
                    <img src="<?php echo esc_url($banner); ?>" class="img-fluid rounded-start" alt="Image">
                    <div class="black"></div>
                    <div class="pr-st">
                        <p><span>Project Status :</span><span class="status"><?php echo $status; ?></span></p>
                    </div>
                </div>
            </div>
            <div class="col-md-7 d-flex flex-column" style="background-color: antiquewhite; padding-left: 0;">
                <div class="card-body">
                    <h3 class="card-title"><?php echo $title; ?></h3>
                    <div class="card-text">
                        <ul>
                            <li><span><i class="fas fa-map-marker-alt"></i> Location :</span> <?php echo $location; ?></li>
                            <li><span><i class="fas fa-user-tie"></i> Engineer :</span> <?php echo $engineer; ?></li>
                            <li><span><i class="fas fa-building"></i> Employer :</span> <?php echo $employer; ?> </li>
                            <li><span><i class="fas fa-calendar-alt"></i> Date of Completion :</span> <?php echo $completion_date; ?></li>
                            <li><span><i class="fas fa-dollar-sign"></i> Funding :</span> <?php echo $funding; ?></li>
                        </ul>
                    </div>
                    <div class="btn-view-details text-right" style="z-index: 99;">
                        <a target="_self" href="<?php echo esc_url(home_url('/project/' . $slug)); ?>" class="btn btn-plain-text-with-arrow">Read more</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
