<?php get_header(); ?>
<style>
    body {
        font-family: Arial, sans-serif;
        scroll-behavior: smooth;
        /* overflow-y: scroll; */
    }

    .main-content {
        margin: 20px 0;
    }

    .project-detail {
        padding: 50px 0;
    }

    .project-detail h2,
    .project-detail h3 {
        font-weight: 700;
    }

    .project-detail h2 {
        font-size: 1.6rem;
        margin-bottom: 20px;
    }

    .project-detail h3 {
        font-size: 24px;
        margin-bottom: 15px;
        margin-top: 0;
    }

    .project-detail p,
    .project-detail ul li,
    .project-detail ol li {
        font-size: 16px;
        line-height: 1.7;
    }

    .project-detail ul {
        padding-left: 20px;
        margin-bottom: 20px;
    }

    .project-detail ul li {
        margin-bottom: 10px;
        list-style-type: none;
    }

    .left-side {
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .right-side {
        padding: 0;
        border-radius: 10px;
        /* box-shadow: 0 0 15px rgba(0, 0, 0, 0.1); */
        height: fit-content;
    }

    .progress {
        height: 1.5rem;
        border-radius: 5px;
    }

    .progress-bar {
        font-size: 16px;
        font-weight: 700;
        padding: 10px;
        background-color: var(--site-color);
    }

    .carousel-item img {
        width: 100%;
        height: 400px;
        object-fit: cover;
        border-radius: 5px;
    }

    .carousel-control-prev,
    i.fa-chevron-left,
    .carousel-control-next,
    i.fa-chevron-right {
        font-size: 24px;
        width: 5%;
        border-radius: 5px;
        color: var(--site-color);
        padding: 5px 10px;

    }

    .carousel-control-prev-icon .fa-chevron-left {
        font-size: 24px;
        width: 5%;
        border-radius: 5px;
        color: var(--site-color);
        padding: 5px 10px;
    }

    .col-md-9 {
        flex: 0 0 73% !important;
    }


    #project-slider {
        margin: 20px auto;
    }


    .srch-btn {
        background-color: var(--site-color);
        color: #fff;
        border: none;
        padding: 7px 15px;
        border-radius: 0px 5px 5px 0px;
        cursor: pointer;
    }

    .srch {
        margin-bottom: 20px;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .more-project {
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .stroke-shape {
        position: relative;
        width: 100px;
        height: 4px;
        border-radius: 30px;
        background: linear-gradient(270deg, black 0, var(--site-color) 100%);
        margin: 0px 0px 20px 0px;
    }

    .card-text ul {
        list-style: none;
        padding: 0;
        margin-bottom: 10px;
    }

    .card-text ul li {
        line-height: 30px;
        font-size: 1rem;
        list-style-type: none
    }

    .card-text ul li span {
        font-weight: bold;
        color: var(--site-color);
        font-family: monospace;
    }

    .card-text ul li span i {
        margin-right: 5px;
        color: #002c42;
    }

    .more-project ul li a {
        padding: 0px 4px;
    }

    /* .more-project ul li .com {
    float: right;
    color: #fff;
    padding: 5px;
    font-weight: bold;
    border-radius: 2px;
    background-color: var(--site-color);
    font-size: 10px;
} */
    /* .more-project ul li .pen {
    float: right;
    color: #fff;
    padding: 5px;
    font-weight: bold;
    border-radius: 2px;
    background-color: #ff0000;
    font-size: 10px;
} */


    /* ============== */

    /* TOC Container */
    .tb-content {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 8px;
        border-left: 4px solid var(--site-color);
        /* max-width: 500px; */
        margin: 20px auto;
    }

    /* TOC Heading */
    .tb-content legend {
        font-size: 18px;
        font-weight: bold;
        color: #fff;
        background: var(--site-color);
        padding: 6px 12px;
        border-radius: 4px;
    }

    /* TOC List */
    .tb-content ol {
        list-style: none;
        padding-left: 10px;
    }



    /* Links */
    .tb-content a {
        text-decoration: none;
        color: var(--site-color);
        padding: 5px 8px;
        display: block;
        transition: 0.2s;
    }

    /* Hover Effect */
    .tb-content a:hover {
        /* background:rgb(224, 245, 255); */
        color: #333;
        border-radius: 4px;
    }

    .tb-content ol {
        list-style: none;
        padding-left: 0;
    }

    .tb-content ol li {
        padding-left: 0
    }

    .tb-content li {
        margin: 8px 0;
        font-size: 15px;
        position: relative;
        padding-left: 3px;
    }

    .tb-content li::before {
        content: "\2022";
        /* Unicode for bullet point */
        color: var(--site-color);
        font-size: 20px;
        position: absolute;
        left: 0;
        top: 0;
    }

    .tb-content ol {
        counter-reset: item;
    }



    .tb-content ol ol {
        counter-reset: subitem;
    }

    .tb-content ol ol>li {
        counter-increment: subitem;
        position: relative;
        padding-left: 10px;
    }

    .tb-content ol ol>li::before {
        content: counter(item) "." counter(subitem) " ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -25px;
    }

    .tb-content ol ol ol {
        counter-reset: subsubitem;
    }

    .tb-content ol ol ol>li {
        counter-increment: subsubitem;
        position: relative;
        padding-left: 25px;
    }

    .tb-content ol ol ol>li::before {
        content: counter(item) "." counter(subitem) "." counter(subsubitem) " ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -25px;
    }




    /* Responsive */
    @media (max-width: 600px) {
        .tb-content {
            max-width: 100%;
            padding: 10px;
        }
    }

    .related-blogs ul {
        padding: 0;
    }

    .related-blogs ul li {
        list-style-type: none;
        margin-bottom: 10px;
        display: flex;
        align-items: center;
        justify-content: flex-start;
    }

    .related-blogs ul li img {
        width: 50px;
        height: 50px;
        border-radius: 5px;
        margin-right: 10px;
    }

    .related-blogs ul li a {
        font-size: .8rem;
        color: var(--site-color);
        text-decoration: none;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;

    }

    .related-blogs ul li a:hover {
        text-decoration: underline;
    }

    .related-blogs h3 {
        font-size: 24px;
        margin-bottom: 20px;
    }

    .project-detail ul li::before {
        content: "\2713";
        /* Unicode for check mark */
        color: var(--site-color);
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-right: 0.5em;
    }

    .project-detail ol {
        counter-reset: item;
        padding-left: 40px;
    }

    .project-detail ol li {
        counter-increment: item;
        margin-bottom: 10px;
        position: relative;
        list-style-type: none;
    }

    .project-detail ol li::before {
        content: counter(item) ". ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -21px;
        /* Adjust as needed */
    }

    .project-detail ul li:hover,
    .project-detail ol li:hover {
        /* background-color: rgba(0, 0, 0, 0.05); */
        cursor: pointer;
    }

    .project-detail ul li:hover::before,
    .project-detail ol li:hover::before {
        color: #333;
        /* Change the color on hover */
    }

    /* aside ol li::before,
.tb-content ol li::before {
    content: none;
} */
    .more-project ul li::before {
        content: none;
    }

    .left-side h1 {
        font-size: 1.6rem;
    }

    /* h2, h3, h4, h5, h6 {
    color: #333;
    margin-top: 20px;
    margin-bottom: 10px;
} */
    .serr ul {
        padding-left: 0;
    }

    .serr ul li {
        margin-bottom: 0px;
        list-style-type: none;
        border-bottom: 1px solid #e9e9e9;
        padding: 5px;
        transition: all 0.45s cubic-bezier(.65, 0, .076, 1);
    }

    .serr ul li:hover {
        background-color: wheat;
    }


    /* @media (max-width: 991px) {
        .right-side {
            display: none;
        }
    } */
    .rows{
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }
    .left-side{
        flex: 0 0 74%;
    }
    .bc{
        position: relative;
    }
    .right-side{
        flex: 0 0 24%;
    }
    .right-side .bc:last-child {
    position: sticky;
    position: -webkit-sticky;
    top: 70px;
}
@media (max-width: 992px) {
        .left-side,
        .right-side {
            flex: 0 0 100% !important;
            max-width: 100%;
        }

        .right-side {
            display: none !important;
        }
    }
    </style>
<div class="main-content">
    <section class="page-title tm-page-title text-left flip text-default page-title-split"
             style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/bb.png);">
        <div class="container padding-extra-large">
            <div class="row"></div>
        </div>
    </section>

    <section class="project-detail">
        <div class="container">
            <div class="rows">

                <div class="left-side ld">
                    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                        <h1><?php the_title(); ?></h1>
                        <hr>

                        <?php if (has_post_thumbnail()) : ?>
                            <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>" alt="Featured Image"
                                 style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">
                        <?php endif; ?>

                        <div class="post-content">
                            <?php the_content(); ?>
                        </div>

                    <?php endwhile; endif; ?>
                </div>

                 <aside class="right-side">
                    <div class="more-project mb-4">
                        <h3>Featured Image</h3>
                        <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>" alt="Featured" style="width: 100%; height: auto; border-radius: 5px;">
                    </div>

                    <!-- Related Posts -->
                    <div class="related-blogs more-project mb-4 bc">
                        <h3>Related Blogs</h3>
                        <div class="stroke-shape"></div>
                        <ul>
                            <?php
                            $related_args = array(
                                'post_type'      => 'post',
                                'posts_per_page' => 3,
                                'post__not_in'   => array(get_the_ID()),
                                'orderby'        => 'rand'
                            );
                            $related_query = new WP_Query($related_args);
                            if ($related_query->have_posts()) :
                                while ($related_query->have_posts()) : $related_query->the_post(); ?>
                                    <li style="display: flex; align-items: center; margin-bottom: 10px;">
                                        <?php if (has_post_thumbnail()) : ?>
                                            <img src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="<?php the_title(); ?>"
                                                style="width: 40px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                        <?php else : ?>
                                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default.jpg"
                                                alt="No Image" style="width: 40px; height: 40px; border-radius: 5px; margin-right: 10px;">
                                        <?php endif; ?>
                                        <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), 10); ?></a>
                                    </li>
                            <?php endwhile;
                                wp_reset_postdata();
                            endif;
                            ?>
                        </ul>
                    </div>

                    <!-- Services -->
                    <?php
                    $services = get_option('services_data', []);
                    ?>

                    <div class="more-project mb-4 serr bc">
                        <h3>Our Services</h3>
                        <div class="stroke-shape"></div>

                        <ul class="service-list">
                            <?php if (!empty($services) && is_array($services)) : ?>
                                <?php foreach ($services as $index => $service) :

                                    $title = !empty($service['service_title']) ? esc_html($service['service_title']) : false;

                                    $image_id = !empty($service['image']) ? intval($service['image']) : 0;
                                    $image_url = $image_id ? wp_get_attachment_url($image_id) : get_template_directory_uri() . '/admin/assets/img/trans.png';
                                    $slug = $title ? sanitize_title($title) : '';

                                    if (!$title) {
                                        echo "<li style='color:red;'>Service #$index is missing title</li>";
                                        continue;
                                    }
                                ?>
                                    <li class="service-item d-flex align-items-center mb-2">
                                        <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($title); ?>" class="service-icon mr-2" style="width:40px;height:40px;border-radius:5px;">
                                        <a href="<?php echo esc_url(home_url('/service/' . $slug)); ?>">
                                            <?php echo $title; ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <li style="color: orange;">No services found in option array.</li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </aside>

            </div>
        </div>
    </section>
</div>

<?php get_footer(); ?>
