jQuery( function($){
	// on upload button click
	$( 'body' ).on( 'click', '.rudr-upload', function( event ){
		event.preventDefault(); // prevent default link click and page refresh
		var button = $(this);
		const imageId = button.next().next().val();
		
		const customUploader = wp.media({
			title: 'Insert image', // modal window title
			library : {
				// uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
				type : 'image'
			},
			button: {
				text: 'Use this image' // button label text
			},
			multiple: false
		}).on( 'select', function() { // it also has "open" and "close" events
			const attachment = customUploader.state().get( 'selection' ).first().toJSON();
            button.closest(".up_img").find("img").attr("src", attachment.url );
            button.closest(".up_img").find("img").css("object-fit", "contain");
            button.closest(".up_img").find(".rudr-upload").hide();
            button.closest(".up_img").find(".rudr-remove").show();
            button.closest(".up_img").find("input").val(attachment.id);
		})
		
		// already selected images
		customUploader.on( 'open', function() {

			if( imageId ) {
			  const selection = customUploader.state().get( 'selection' )
			  attachment = wp.media.attachment( imageId );
			  attachment.fetch();
			  selection.add( attachment ? [attachment] : [] );
			}
			
		})

		customUploader.open()
	
	});
	// on remove button click
	$( 'body' ).on( 'click', '.rudr-remove', function( event ){
		event.preventDefault();
        let f = window.confirm("Do you want to delete image?");
        if(f){
            var button = $(this);
            var def = button.closest(".up_img").find("img").attr("data-def");
            button.closest(".up_img").find("img").removeAttr("style");
            button.closest(".up_img").find("img").attr("src", def );
            button.closest(".up_img").find(".rudr-upload").show();
            button.closest(".up_img").find(".rudr-remove").hide();
            button.closest(".up_img").find("input").val("");
        }
	});

    $("body").on("click", "._del_tbl", function(e){
        if(window.confirm("Do you want to continue?")){
            $(this).closest("tr").remove();
        }
        return false;
    });

    $("body").on("click", "._del_href", function(e){
        if(window.confirm("Do you want to continue?")){
            return true;
        }
        return false;
    });

    $("body").on("click", "._del_ad", function(){
        if(window.confirm("Do you want to continue?")){
            $(this).closest(".inp").remove();
        }
        return false;
    });

    $("body").on("click", ".dg-modal-open", function(){
        let modal = $(this).attr("data-modal");
        $(".dg-modal."+modal).css("display", "flex");
        return false;
    });

    $("body").on("click", ".dg-modal-close", function(){
        $(this).closest(".dg-modal").hide();
    });
});
