<?php

add_action('wp_ajax_get_most_viewed_via_period', 'get_most_viewed_via_period_callback');
add_action('wp_ajax_nopriv_get_most_viewed_via_period', 'get_most_viewed_via_period_callback');
function get_most_viewed_via_period_callback(){
    $post_type = $_POST["type"];
    $period = $_POST["period"];
    $from = "";
    $to = "";
    if ($period == "today"){
        $from = date("Y-m-d");
    }elseif ($period == "yesterday"){
        $from = date("Y-m-d", strtotime("-1 day"));
    }elseif($period == "this_week"){
        $from = date("Y-m-d", strtotime('monday this week'));
        $to = date("Y-m-d");
    }elseif($period == "last_week"){
        $from = date("Y-m-d", strtotime('monday last week'));
        $to = date("Y-m-d", strtotime('sunday last week'));
    }elseif($period == "this_month"){
        $from = date("Y-m-01");
        $to = date("Y-m-d");
    }elseif($period == "last_month"){
        $from = date("Y-m-01", strtotime("first day of last month"));
        $to = date("Y-m-t", strtotime("last day of last month"));
    }elseif($period == "three_month"){
        $from = date("Y-m-d", strtotime("-3 months"));
        $to = date("Y-m-d");
    }elseif($period == "six_month"){
        $from = date("Y-m-d", strtotime("-6 months"));
        $to = date("Y-m-d");
    }elseif($period == "year"){
        $from = date("Y-01-01");
        $to = date("Y-m-d");
    }
    global $wpdb;
    $table_name = get_view_table();
    $posts = $wpdb->prefix."posts";
    if ($to == ""){
        $dates = " and v.date = '$from'";
    }else{
        $dates = " and v.date <='$to'  and v.date >='$from'";
    }
        
    $sql = "SELECT sum(v.views) as views, p.post_title, v.post_id 
            FROM $table_name v 
            LEFT JOIN $posts p ON v.post_id = p.ID 
            WHERE p.post_status='publish' 
              AND p.post_type='$post_type' 
              $dates 
            GROUP BY v.post_id ORDER BY v.views DESC LIMIT 10";
    $p=  $wpdb->get_results($sql);
    $html = "";
    foreach($p as $k=>$v){
        if ($post_type=="tool"){
            $term = get_term(get_post_meta($v->post_id, "tool_category", true));
            $slug = get_post_meta($v->post_id, 'slug', true);
            $term_link = get_term_link($term);
            $slug = get_post_field('post_name', $v->post_id);
            $link = home_url("tool/".$slug);
        }elseif($post_type=="post"){
            $terms = get_the_terms($v->post_id, 'category');
            $term = !empty($terms) && !is_wp_error($terms) ? $terms[0] : null;
            if ($term) {
                $term_link = get_term_link($term);
            } else {
                $term_link = '#';
            }
            $link = get_permalink($v->post_id);
        }
        $views = get_post_meta($v->post_id, "views", true);
        $html .= "<tr>
            <td style='text-align:center;'>".($k+1)."</td>
            <td><a href='$link' target='_blank'>$v->post_title</a></td>
            <td>
                <a href='$term_link' target='_blank'>$term->name</a>
            </td>
            <td style='text-align:center;'>$v->views</td>
            <td style='text-align:center;'>$views</td>
        </tr>";
    }
    echo $html;
    die();
}