<script>

        function _popup(obj){
            if (typeof obj === "undefined") {
                obj = {};
            }
            obj.title = obj.title || "Confirmation";
            obj.content = obj.content || "Do you want to continue?";
            obj.btnOk = obj.btnOk || "OK";
            obj.btnCancel = obj.btnCancel || "Cancel";
            obj.color = obj.color ? "popup-btn-"+obj.color :  "popup-btn-grey";
            obj.action = obj.action ? "data-href="+obj.action : "";
            const popup = document.createElement("div");
            popup.classList.add("popup");
            popup.innerHTML = `
                <div class="popup-content">
                    <h3>${obj.title} <span class="dashicons dashicons-warning"></span></h3>
                    <p>${obj.content}</p>
                    <div class="popup-actions">
                        <button class="cancel-btn">${obj.btnCancel}</button>
                        <button ${obj.action} class="confirm-btn ${obj.color}">${obj.btnOk}</button>
                    </div>
                    <div class="boll"></div>
                </div>`;
            document.body.appendChild(popup);
           
            const cancelBtn = popup.querySelector(".cancel-btn");
            cancelBtn.addEventListener("click", function () {
                popup.remove();  
            });

            const confirmDeleteBtn = popup.querySelector(".confirm-btn");
            if (confirmDeleteBtn) {
                confirmDeleteBtn.addEventListener("click", function () {
                    const href = this.getAttribute('data-href');
                    if (href) {
                        window.location.href = href;
                    }
                    popup.remove();
                });
            }
        }

  
</script>
<style>
        .popup {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .popup-content {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            width: 300px;
            text-align: center;
            transition: opacity 0.3s ease;
            opacity: 1;
            border: 3px solid #ccc;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow: hidden;
            z-index: 1;
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .popup-content .dashicons-warning{
            animation: blink 1s infinite;
            color:rgb(232, 94, 108);
        }
        @keyframes blink {
                0%, 100% {
                    opacity: 1;
                }
                50% {
                    opacity: 0;
                }
            }

        .popup-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            background: linear-gradient(to right,rgb(255, 255, 255), #4285f4);
            clip-path: circle(2rem at 1% 0%);
            transition: .5s linear;
            opacity: 0.2;
            z-index: 0;
        }
        .popup-content:hover::before {
            clip-path: circle(200% at 100% 0%);
            transition: .5s linear;
            cursor: pointer;
        }

        .popup-content:hover .boll {
            background-color: #28a745;
        }

        .popup-content h3 {
            margin-bottom: 15px;
            margin-top: 0px;
            font-size: 18px;
            color: #333;
        }

        .popup-content p {
            margin: 0 0 20px;
            font-size: 14px;
            color: #333;
        }

        .popup-content form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .popup-actions {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .popup-actions button {
            padding: 5px 25px;
            border: none;
            border-radius: 3px;
            cursor: pointer;
            z-index: 9999;
        }
        .popup-actions button:hover {
            opacity: 0.8;
        }

        .cancel-btn {
            background: #007bff;
            color: #fff;
        }

        .popup-btn-red {
            background:  #dc3545;
            color: #fff;
        }
        .popup-btn-green {
            background: #28a745;
            color: #fff;
        }
        .popup-btn-orange {
            background:rgb(255, 85, 7);
            color: #fff;
        }
        .popup-btn-grey {
            background:rgb(89, 89, 89);
            color: #fff;
        }
</style>