<?php
$status = get_option("lga_views_on_off","on");
    // Fetch categories
    $categories = get_categories(array(
        'orderby' => 'name',
        'order'   => 'ASC'
    ));

    // Get selected category from query string
    $selected_category = isset($_GET['ctg']) ? intval($_GET['ctg']) : 0;
    // Fetch posts from selected category
    $posts = array();
    if ($selected_category) {
        $posts = get_posts(array(
            'category' => $selected_category,
            'numberposts' => -1,
            'post_status' => 'publish'
        ));
    }

    // Fetch 'tool-list' taxonomy terms
    $tool_categories = get_terms(array(
        'taxonomy' => 'tool-list',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ));
?>

    <div class="ctn">
        
        <div class="inp-info" style="background:#e7eff7;padding:20px 10px;color:darkblue;margin-top:0px;border-radius:10px;">
            <label style="font-weight:bold;">Enable Views Counter</label>
            &nbsp; &nbsp; 
            <label class="switch">
                <input type="checkbox" id="togBtn" class="onoff" <?php if($status=="on"){echo "checked";} ?>>
                <div class="slider round"></div>
            </label>    
        </div>
        <div class="inp menu">
            <label><strong>Select Category</strong></label>
            <select name="ctg">
                <option value="">--- Select ---</option>
                <optgroup label="Blog Categories">
                    <?php foreach ($categories as $category): ?>
                        <option value="blog-<?php echo $category->term_id; ?>" <?php echo $selected_category == $category->term_id ? 'selected' : ''; ?>>
                            <?php echo $category->name; ?>
                        </option>
                    <?php endforeach; ?>
                </optgroup>
                <optgroup label="Tool Categories">
                    <?php foreach ($tool_categories as $category): ?>
                        <option value="tool-<?php echo $category->term_id; ?>" <?php echo $selected_category == $category->term_id ? 'selected' : ''; ?>>
                            <?php echo $category->name; ?>
                        </option>
                    <?php endforeach; ?>
                </optgroup>
            </select>
        </div>
        <div class="term-table">
            <h2>List of Posts <small>(Select Category)</small> </h2>
            <table style="width:100%" id="myTable">
                <thead>
                    <tr>
                        <th>Sr</th>
                        <th>Title</th>
                        <th>Actual</th>
                        <th>Increment</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($posts)): ?>
                        <?php foreach ($posts as $index => $post): ?>
                            <?php
                                // Fetch custom fields or meta data for the post
                                $actual_views = get_post_meta($post->ID, 'views', true) ?: 0;
                                // $actual_views = get_post_meta($post->ID, 'actual_views', true) ?: 0;
                                $increment = get_post_meta($post->ID, 'increment', true) ?: 0;
                                $total_views = $actual_views + $increment;
                            ?>
                            <tr data-id="<?php echo $post->ID; ?>">
                                <td class="n"><?php echo $index + 1; ?></td>
                                <td><a href="<?php echo get_permalink($post->ID); ?>"><?php echo $post->post_title; ?></a></td>
                                <td class="n"><?php echo $actual_views; ?></td>
                                <td><input type="number" value="<?php echo $increment; ?>" data-post-id="<?php echo $post->ID; ?>" class="increment-input"></td>
                                <td class="t"><?php echo $total_views; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="text-align: center;">No posts found for the selected category.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="dg-btns btn-right">
            <button class="save">Save</button>
        </div>
        <style>
            .term-table { margin:20px 0px; }
            table { border-collapse:collapse; width: 100%; }
            .term-table thead { background:#000; color:#fff; }
            .term-table thead th {
                font-size:16px;
                text-align:left;
                font-weight: bold;
                padding:10px;
                cursor:pointer;
            }
            .term-table td {
                padding: 8px 10px;
                border-bottom: 1px solid #ccc;
                text-align: left;
            }
            .term-table td a{
                color:#000;
                text-decoration:none;
            }
            .rw-red { background:rgba(255,0,0,0.1); }
        
        </style>
                
    </div>
<script>
    (function($){
        $(document).ready(function(){
            $(".onoff").click(function(){
                if($(this).is(":checked")){
                    $(".menu").show();
                    $("select[name='ctg']").val("");
                    $(".term-table tbody").html("");
                    $(".term-table").show();
                }else{
                    $(".menu").hide();
                    $(".term-table").show().hide();
                    $(".term-table tbody").hide();
                }
            });

            $("select[name='ctg']").change(function(){
                let id = $(this).val();
                if(id == ""){
                    $(".term-table tbody").html("");
                }else{
                    $(".term-table tbody").show();
                    jQuery.ajax({
                        type : "post",
                        dataType : "html",
                        url : "<?php echo home_url("wp-admin/admin-ajax.php"); ?>" ,
                        data : {action: "my_post_list", id : id},
                        success: function(resp) {
                            if(resp.trim()==""){
                                $(".term-table tbody").html("");
                                alert("There is not post in the category.");
                            }else{
                                $(".term-table tbody").html(resp);
                            }
                            
                        }
                    })   
                }
            });
            $("body").on("keyup", "table input[type='number']",function(){
                let v = isNaN(parseInt($(this).val())) ? 0 : parseInt($(this).val());
                let n = parseInt($(this).closest("tr").find(".n").text());

                $(this).closest("tr").find(".t").text(v + n);

            });
            $("body").on("click", "button.save",function(){
                let posts = [];
                if($(".onoff").is(":checked")){
                    $(".term-table tbody tr").each(function(){
                        posts.push(
                            {
                                id : $(this).attr("data-id"),
                                views : $(this).find("input").val()
                            });
                    });
                }
                let status = $(".onoff").is(":checked") ? "on" : "off";
                jQuery.ajax({
                    type : "post",
                    dataType : "html",
                    url : "<?php echo home_url("wp-admin/admin-ajax.php"); ?>" ,
                    data : {action: "my_post_fake", posts : posts, status : status},
                    success: function(resp) {
                        alert("Data Saved successfully.");
                    }
                });
            });
        
        });
    })(jQuery)
</script>
    