<style>
    /* Table styling */
    .theme_form .tbl {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .theme_form .tbl th,
    .theme_form .tbl td {
        border: 1px solid #ddd;
        padding: 7px;
        text-align: center;
        font-size: 14px;
        color: #333;
    }

    .theme_form .tbl th {
        background-color: #f4f4f4;
        color: #333;
        font-weight: bold;
    }

    .theme_form .tbl td {
        vertical-align: middle;
        font-weight: 500;
    }

    /* Color input field with preview */
    .clr-field {
        display: flex;
        align-items: center;
        gap: 8px;
        position: relative;
    }

    .clr-field button {
        width: 30px;
        height: 30px;
        border: none;
        background-color: currentColor;
        border-radius: 4px;
        cursor: pointer;
    }

    .clr-field input[type="text"] {
        width: 100px;
        padding: 6px 10px;
        border: none;
        border-radius: 4px;
        font-family: monospace;
    }

    /* Remove outline on input focus */
    .clr-field input[type="text"]:focus,
    .clr-field input[type="color"]:focus {
        outline: none;
        box-shadow: none;
        border: none;
    }

    /* Reset link */
    .reset-theme {
        color: #d63638;
        background-color: #fff5f5;
        border: 1px solid #d63638;
        padding: 8px 12px;
        border-radius: 2px;
        transition: background-color 0.3s ease;
        display: inline-block;
        float: right;
        text-align: center;
        font-size: 14px;
        font-weight: 500;
        text-decoration: none;
    }

    .reset-theme:hover {
        background-color: #d63638;
        color: #fff;
        text-decoration: none;
    }

    /* Submit button styling */
    .form-submit {
        margin-top: 20px;
        text-align: right;
    }

    .form-submit .btn {
        background-color: #007cba;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 4px;
        font-size: 15px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .form-submit .btn:hover {
        background-color: #006799;
    }

    ._colors {
        width: 100%;
        height: 35px;
        border: none;
        border-radius: 4px !important;
        cursor: pointer;
        padding: 0;
        margin: 0;
        outline: none;
        border: none !important;
    }
</style>
<?php
$colors_list = array(
    "site_color" => "#e28413",
    "first_box" => "#000000",
    "second_box" => "#14213d",
    "third_box" => "#e28413",

);
function lga_get_css_file($file){
	ob_start();
	$path = rtrim(get_template_directory(), "/")."/assets/css/".$file;
	include $path;
	$data = ob_get_contents();
	ob_get_clean();
	return $data;
	
}
function dgaps_update_css_file($data){
    $file_index = lga_get_css_file("slider.css");

    $path = rtrim(get_template_directory(), "/")."/";
	
    foreach($data as $key=>$value){
        $var = str_replace("_", "-", $key);
        $var = "--".$var;
        $row = $var.":".$value;
        $file_index = preg_replace("/$var:#[0-9A-Za-z]+/", $row, $file_index);
    }
    $mfile = fopen($path."assets/css/slider.css", "w");
	
    fwrite($mfile, $file_index);
    fclose($mfile);
}
?>
<form method="post" action="" class="theme_form">
    <div class="dg-btns btn-right">
        <a href="?page=smecon-settings&pg=colors&reset=true" class="reset-theme _del_href">Reset Theme Colors</a>
    </div>
    <?php
    if (isset($_POST["submit"])) {
        $data = $_POST;
        unset($data["submit"]);
        update_option("lga_theme", $data);

        // Save Version
        $version = get_option("lga-version", 1);
        if (is_numeric($version)) {
            $version += 1;
        } else {
            $version = 1;
        }
        update_option("lga-version", $version);

        dgaps_update_css_file($data);
        header("location:?page=smecon-settings&pg=colors&s=1");
        exit;

    } elseif (isset($_GET["reset"])) {
        delete_option("lga_theme");
        $data = $colors_list;
        dgaps_update_css_file($data);

        $version = get_option("lga-version", 1);
        if (is_numeric($version)) {
            $version += 1;
        } else {
            $version = 1;
        }
        update_option("lga-version", $version);
        header("location:?page=smecon-settings&pg=colors&s=1");
        exit;

    } elseif (isset($_GET["s"])) {
        echo "<div class='alert alert-success'>Data has been saved successfully.</div>";
    }
        $op = get_option("lga_theme");
        $op = ($op == "") ? $colors_list : $op;
        extract($op);
    ?>
    <table class="tbl" style="margin-bottom: 20px;">
        <thead>
            <tr>
                <th style="width:40px;">Sr.</th>
                <th style="text-align:left;">Description</th>
                <th style="width:100px;">HEX Code</th>
                <th style="width:100px;">Color</th>
            </tr>
        </thead>
        <tbody>

            <tr>
                <td>1</td>
                <td style="text-align:left;">Site Color</td>
                <td><?php echo $site_color; ?></td>
                <td>
                    <div class="clr-field">
                        <input type="color" name="site_color" value="<?php echo $site_color; ?>" class="field _colors">
                    </div>
                </td>
            </tr>
            <tr>
                <td>2</td>
                <td style="text-align:left;">First Box Color</td>
                <td><?php echo $first_box; ?></td>
                <td>
                    <div class="clr-field"><input type="color" name="first_box" value="<?php echo $first_box; ?>" class="field _colors">
                    </div>
                </td>
            </tr>
            <tr>
                <td>3</td>
                <td style="text-align:left;">Second Box Color</td>
                <td><?php echo $second_box; ?></td>
                <td>
                    <div class="clr-field"><input type="color" name="second_box" value="<?php echo $second_box; ?>" class="field _colors">
                    </div>
                </td>
            </tr>
            <tr>
                <td>4</td>
                <td style="text-align:left;">Third Box Color</td>
                <td><?php echo $third_box; ?></td>
                <td>
                    <div class="clr-field"><input type="color" name="third_box" value="<?php echo $third_box; ?>" class="field _colors">
                    </div>
                </td>
            </tr>
            
        </tbody>
    </table>

    <div class="dg-btns btn-right">
        <button type="submit" name="submit" class="btn">Save</button>
    </div>
</form>