<style>
  .branding-container {
    /* max-width: 900px; */
    margin: 0 auto;
    font-family: Arial, sans-serif;
  }

  h2 {
    margin-top: 30px;
    color: #222;
    font-size: 22px;
    padding-bottom: 5px;
  }

  .input-group {
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: space-between;
    margin: 15px 0;
    gap: 20px;
  }

  .input-group label {
    font-weight: bold;
    /* min-width: 150px; */
  }

  .input-group input[type="text"] {
    flex: 1;
    min-width: 200px;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
  }

  .image-section {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    justify-content: space-around;
    margin-bottom: 20px;
  }

  .image-box {
    flex: 1 1 calc(33.333% - 20px);
    box-sizing: border-box;
    position: relative;
  }

  .image-box label {
    display: block;
    font-weight: bold;
  }

  .upload-wrap {
    border: 1px solid #ddd;
    padding: 10px;
    background: #f9f9f9;
    text-align: center;
    position: relative;
  }

  .upload-wrap img {
    max-width: 100%;
    height: auto;
    margin-bottom: 10px;
  }

  .img label {
    font-size: 12px;
    color: #666;
    margin-bottom: 10px;
  }

  .upload-btn,
  .remove-btn {
    display: inline-block;
    background: #0073aa;
    color: #fff;
    padding: 5px 10px;
    text-decoration: none;
    border-radius: 4px;
    font-size: 13px;
    margin-top: 5px;
  }

  .remove-btn {
    background: red;
    position: absolute;
    top: 5px;
    right: 5px;
  }

  .aspect-note {
    text-align: center;
    display: flex;
    flex-direction: column;
    justify-content: center;
    background: #f5f5f5;
    padding: 10px;
    height: 100%;
    border: 1px dashed #ccc;
  }

  .info-box {
    background: #f1f1f1;
    padding: 15px;
    margin-top: 20px;
    border-left: 4px solid #0073aa;
    text-align: left;
  }



  .comment-options {
    display: flex;
    gap: 15px;
    align-items: center;
  }

  .comment-options label {
    font-weight: normal;
    display: flex;
    align-items: center;
    gap: 5px;
  }

  .social-inputs .input-group {
    display: flex;
    align-items: center;
  }

  .social-inputs .input-group label {
    display: flex;
    align-items: center;
    gap: 8px;
    min-width: 150px !important;
  }

  .social-inputs .input-group img {
    max-width: 20px;
  }

  .form-footer {
    text-align: right;
    margin-top: 20px;
  }

  .form-footer button {
    background: #0073aa;
    color: #fff;
    border: none;
    padding: 10px 20px;
    font-weight: bold;
    border-radius: 4px;
    cursor: pointer;
  }

  .my-4 {
    margin-bottom: 40px;
  }

  /* @media screen and (max-width: 768px) {
    .image-box {
      flex: 1 1 100%;
    }

    .input-group {
      flex-direction: column;
      align-items: flex-start;
    }

    .input-group input {
      width: 100%;
    }
  } */

  .rps {
    background-color: #fbfbfb;
    margin-bottom: 25px;
    border-radius: 10px;
  }

  .inn {
    padding: 20px;
  }

  .rps h3 {
    background: linear-gradient(to right, rgb(225, 225, 225), rgb(255, 214, 182));
    padding: 10px;
    border-radius: 10px 10px 0px 0px;
    color: black;
    text-align: center;
  }

  .inp {
    border-bottom: none;
  }
</style>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    $options = array(
        'logo' => $_POST['logo'],
        'favicon' => $_POST['favicon'],
        'og_image' => $_POST['og_image'],
        'facebook' => $_POST['facebook'],
        'youtube' => $_POST['youtube'],
        'linkedin' => $_POST['linkedin'],
        'instagram' => $_POST['instagram'],
        'footer_short_info' => $_POST['footer_short_info'],
        'contact_number' => $_POST['contact_number'],
        'contact_email' => $_POST['contact_email'],
        'Video_link' => $_POST['Video_link'],
    );

    update_option('lga_settings', $options);

    wp_redirect($_SERVER['REQUEST_URI'] . "&s=1");
    exit;
}

if (isset($_GET["s"])) {
    echo "<div class='alert alert-success'>Data has been saved successfully.</div>";
}

$options = get_option("lga_settings");
if (!empty($options)) {
    extract($options);
}
$logo_id = $logo;
$logo = !empty($logo_id) ? wp_get_attachment_image_url($logo_id, 'full') : '';

$favicon_id = $favicon;
$favicon = !empty($favicon_id) ? wp_get_attachment_image_url($favicon_id, 'full') : '';

$og_id = $og_image;
$og_image = !empty($og_id) ? wp_get_attachment_image_url($og_id, 'full') : '';


?>

<div class="branding-container">
  <form method="post" action="">


    <div class="image-section my-4">
      <div class="img">
        <label>Logo <small>( Size: 200 x 40)</small></label>
        <div class="up_img">
          <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
          <img src="<?php echo ($logo != "") ? $logo :  get_template_directory_uri() . "/admin/assets/img/trans.png"; ?>">
          <a href="#" class="button rudr-upload">Upload image</a>
          <input type="hidden" name="logo" value="<?php echo $logo_id; ?>">
        </div>
      </div>
      <div class="img">
        <label>Favicon <small>(Size: 40 x 40)</small></label>
        <div class="up_img">
          <img src="<?php echo ($favicon != "") ? $favicon : get_template_directory_uri() . "/admin/assets/img/trans.png"; ?>">
          <a href="#" class="button rudr-upload">Upload image</a>
          <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
          <input type="hidden" name="favicon" value="<?php echo $favicon_id; ?>">
        </div>
      </div>
      <!-- <div class="img">
        <label>OG Image <small>(Size: 1200 x 630)</small></label>
        <div class="up_img">
          <img src="<?php echo ($og_image != "") ? $og_image : get_template_directory_uri() . "/admin/assets/img/trans.png"; ?>">
          <a href="#" class="button rudr-upload">Upload image</a>
          <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
          <input type="hidden" name="og_image" value="<?php echo $og_id; ?>">
        </div>
      </div> -->
      <div class="img">
        <label style="display:block;text-align:center;">Featured Image</label>
        <div class="up_img" style="display:flex;align-items:center; flex-direction:column;justify-content:center">
          <span style="font-size:18px;">Aspect Size</span><br>
          <strong style="font-size:22px;">300 x 200</strong>
        </div>
      </div>
    </div>

    <div class="rps">
      <h3 style="margin-bottom: 0px;">Navbar Contacts</h3>
      <div class="inn">
        <div class="inp input-group">
          <label for="contact_number">Contact Number:</label>
          <input type="text" id="contact_number" name="contact_number" value="<?php echo isset($options['contact_number']) ? esc_attr($options['contact_number']) : ''; ?>" placeholder="e.g +1234567890">
        </div>
        <div class="inp input-group">
          <label for="contact_email">Contact Email:</label>
          <input type="text" id="contact_email" name="contact_email" value="<?php echo isset($options['contact_email']) ? esc_attr($options['contact_email']) : ''; ?>" placeholder="e.g info@example.com">
        </div>
      </div>
    </div>

    <div class="rps">
      <h3 style="margin-bottom: 0px;">Footer</h3>
      <div class="inn">
        <div class="inp input-group">
          <label for="footer_short_info">Short Info:</label>
          <textarea name="footer_short_info" id="footer_short_info" rows="4" style="flex:1"><?php echo $footer_short_info ?? ""; ?></textarea>
        </div>
        <small>Enter the short info, that is under the footer logo.</small>
        <hr>
        <div class="inp input-group">
          <label for="Video_link">YouTube Video Link:</label>
          <input type="text" id="Video_link" name="Video_link" value="<?php echo isset($options['Video_link']) ? esc_attr($options['Video_link']) : ''; ?>" placeholder="https://www.youtube.com/watch?v=abc123">
        </div>

      </div>
    </div>


    <div class="rps" style="margin-top: 20px;">
      <h3 style="margin:0px">Social Media Links</h3>
      <div class="inn">
        <div class="social-inputs">
          <div class="input-group">
            <label><img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/facebook.webp" alt="Facebook Icon">Facebook</label>
            <input type="text" name="facebook" value="<?php echo $facebook; ?>" placeholder="https://facebook.com/yourpage">
          </div>
          <div class="input-group">
            <label><img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/youtube.webp" alt="YouTube Icon">YouTube</label>
            <input type="text" name="youtube" value="<?php echo $youtube; ?>" placeholder="https://youtube.com/yourchannel">
          </div>
          <div class="input-group">
            <label> <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/linkdin.webp" alt=""> LinkedIn</label>
            <input type="text" name="linkedin" value="<?php echo $linkedin; ?>" placeholder="https://linkedin.com/in/yourprofile">
          </div>
          <div class="input-group">
            <label><img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/instagram.webp" alt="Instagram Icon">Instagram</label>
            <input type="text" name="instagram" value="<?php echo $instagram; ?>" placeholder="https://instagram.com/yourprofile">
          </div>

        </div>
      </div>
    </div>

    <div class="dg-btns btn-right">
      <button type="submit" name="submit">Save</button>
    </div>
  </form>
</div>