<form method="post" action="">
<?php
if (isset($_POST["save"])) {
    $tool_names = $_POST['tool_name'] ?? [];
    $tool_descriptions = $_POST['tool_description'] ?? [];
    $tool_banners = $_POST['banner'] ?? [];

    $tools = [];
    for ($i = 0; $i < count($tool_names); $i++) {
        $tools[] = array(
            'name'        => sanitize_text_field($tool_names[$i]),
            'description' => sanitize_text_field($tool_descriptions[$i]),
            'banner'      => intval($tool_banners[$i]),
        );
    }

    $health_data = array(
        'health_banner_title'  => sanitize_text_field($_POST['health_banner_title'] ?? ''),
        'health_section_title' => sanitize_text_field($_POST['health_section_title'] ?? ''),
        'health_description'   => wp_kses_post($_POST['health_description'] ?? ''),
        'tools' => $tools,
    );

    update_option('health_safety_data', $health_data);
    echo "<div class='alert alert-success'>Data saved successfully.</div>";
}

$health_data = get_option('health_safety_data');
$health_banner_title  = $health_data['health_banner_title'] ?? '';
$health_section_title = $health_data['health_section_title'] ?? '';
$health_description   = $health_data['health_description'] ?? '';
$tools = $health_data['tools'] ?? [];
?>

<div class="ctn">
    <div class="rps">
        <h3>Health & Safety Banner</h3>
        <div class="inn">
            <div class="inp input-group">
                <label><strong>Banner Title:</strong></label>
                <input type="text" name="health_banner_title" value="<?php echo esc_attr($health_banner_title); ?>" placeholder="Enter Banner Title">
            </div>
        </div>
    </div>

    <div class="rps">
        <h3>Health Section</h3>
        <div class="inn">
            <div class="inp input-group">
                <label><strong>Section Title:</strong></label>
                <input type="text" name="health_section_title" value="<?php echo esc_attr($health_section_title); ?>" placeholder="Enter Section Title">
            </div>
            <hr>
            <div class="inp">
                <?php 
                    $settings = array(
                        'textarea_name' => 'health_description',
                        'media_buttons' => true,
                        'textarea_rows' => 10,
                        'teeny' => false,
                        'quicktags' => true
                    );
                    wp_editor($health_description, 'health_description', $settings); 
                ?>
            </div>
        </div>
    </div>

    <div class="rps">
        <h3>Health & Safety Tools</h3>
        <div class="inn">
            <div id="tools-container">
                <?php foreach ($tools as $tool): ?>
                    <div class="tool-r single-tool-entry">
                        <div class="inp input-group">
                            <label>Tool Name:</label>
                            <input type="text" name="tool_name[]" value="<?php echo esc_attr($tool['name']); ?>" placeholder="Tool Name">
                        </div>
                        <div class="inp input-group">
                            <label>Tool Description:</label>
                            <input type="text" name="tool_description[]" value="<?php echo esc_attr($tool['description']); ?>" placeholder="Tool Description">
                        </div>
                        <div class="inp input-group">
                            <label>Banner:</label>
                            <div class="img">
                                <div class="up_img" style="width: 300px;">
                                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                    <img src="<?php echo $tool['banner'] ? esc_url(wp_get_attachment_url($tool['banner'])) : get_template_directory_uri() . '/admin/assets/img/trans.png'; ?>" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                    <a href="#" class="button rudr-upload">Upload image</a>
                                    <input type="hidden" name="banner[]" value="<?php echo esc_attr($tool['banner']); ?>">
                                </div>
                            </div>
                        </div>
                        <button class="remove-tool-row button">Remove</button>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Hidden Template -->
            <div class="tool-r single-tool-entry template" style="display: none;">
                <div class="inp input-group">
                    <label>Tool Name:</label>
                    <input type="text" name="tool_name[]" placeholder="Tool Name" disabled>
                </div>
                <div class="inp input-group">
                    <label>Tool Description:</label>
                    <input type="text" name="tool_description[]" placeholder="Tool Description" disabled>
                </div>
                <div class="inp input-group">
                    <label>Banner:</label>
                    <div class="img">
                        <div class="up_img" style="width: 300px;">
                            <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                            <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                            <a href="#" class="button rudr-upload">Upload image</a>
                            <input type="hidden" name="banner[]" value="" disabled>
                        </div>
                    </div>
                </div>
                <button class="remove-tool-row button">Remove</button>
            </div>

            <a href="#" class="dgh-add-row dg-btn" style="float:left;">+ Add Tool</a>
        </div>
    </div>

    <div class="dg-btns btn-right">
        <button class="save" name="save">Save</button>
    </div>
</div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const container = document.getElementById('tools-container');

    document.querySelector('.dgh-add-row').addEventListener('click', function (e) {
        e.preventDefault();
        const template = document.querySelector('.template').cloneNode(true);
        template.classList.remove('template');
        template.style.display = 'block';

        // Enable inputs before appending
        template.querySelectorAll('input').forEach(input => input.removeAttribute('disabled'));

        container.appendChild(template);
    });

    container.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-tool-row')) {
            e.preventDefault();
            e.target.closest('.single-tool-entry').remove();
        }
    });
});
</script>

<style>
#tools-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
    margin-bottom: 20px;
}
.tool-r {
    border: 1px solid #ddd;
    padding: 20px;
    border-radius: 8px;
    background: #f9f9f9;
}
.rps {
    background-color: #fbfbfb;
    margin-bottom: 25px;
    border-radius: 10px;
}
.inn {
    padding: 20px;
}
.rps h3 {
    background: linear-gradient(to right, rgb(225, 225, 225), rgb(255, 214, 182));
    padding: 10px;
    border-radius: 10px 10px 0px 0px;
    color: black;
    text-align: center;
}
.input-group {
    display: flex;
    align-items: center;
    gap: 20px;
    margin-bottom: 20px;
    flex-wrap: wrap;
}
.input-group label {
    width: 200px;
    font-weight: bold;
    text-align: left;
}
.input-group input, .input-group textarea {
    flex: 1;
    min-width: 250px;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    width: 100%;
}
.dg-btns {
    text-align: right;
    margin-top: 20px;
}
</style>
