<?php
if (isset($_POST["save"])) {
    $home_page_data = array(
        'banner' => isset($_POST['banner']) ? array_filter(array_map('intval', $_POST['banner'])) : [],
        'mobile_banner' => isset($_POST['mobile_banner']) ? array_filter(array_map('intval', $_POST['mobile_banner'])) : [],
        'offers' => []
    );

    if (isset($_POST['offer_title']) && is_array($_POST['offer_title'])) {
        foreach ($_POST['offer_title'] as $i => $title) {
            $iconimage = isset($_POST['iconimage'][$i]) ? intval($_POST['iconimage'][$i]) : 0;
            $offer_title = sanitize_text_field($title);
            $offer_description = isset($_POST['offer_description'][$i]) ? sanitize_textarea_field($_POST['offer_description'][$i]) : '';

            if (!empty($offer_title) || !empty($offer_description) || !empty($iconimage)) {
                $home_page_data['offers'][] = array(
                    'iconimage' => $iconimage,
                    'offer_title' => $offer_title,
                    'offer_description' => $offer_description
                );
            }
        }
    }

    update_option('home_page_data', $home_page_data);
    echo "<div class='alert alert-success'>Data has been saved successfully.</div>";
}

$home_page_data = get_option('home_page_data');
$banner_ids = isset($home_page_data['banner']) && is_array($home_page_data['banner']) ? $home_page_data['banner'] : [];
$offer_data = isset($home_page_data['offers']) && is_array($home_page_data['offers']) ? $home_page_data['offers'] : [];

if (empty($banner_ids)) {
    $banner_ids[] = 0;
}
?>

<form method="post" action="">
    <div class="ctn">
        <div class="rps">
            <h3>Home Page Slider For Desktop</h3>
            <div class="inn">
                <div id="banner-container">
                    <?php foreach ($banner_ids as $banner) : ?>
                        <div class="inp input-group">
                            <div class="img">
                                <p><strong>Preferred Image Size: 1200 x 400</strong></p>
                                <div class="up_img" style="width: 300px;">
                                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                    <img src="<?php echo $banner ? esc_url(wp_get_attachment_url($banner)) : get_template_directory_uri() . '/admin/assets/img/trans.png'; ?>" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                    <a href="#" class="button rudr-upload">Upload image</a>
                                    <input type="hidden" name="banner[]" value="<?php echo esc_attr($banner); ?>">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <div class="inp input-group template" style="display:none;">
                        <div class="img">
                            <p><strong>Preferred Image Size: 1200 x 400</strong></p>
                            <div class="up_img" style="width: 300px;">
                                <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                <a href="#" class="button rudr-upload">Upload image</a>
                                <input type="hidden" name="banner[]" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <a href="#" class="dgh-add-row-desktop dg-btn" style="float:left;">+ Add Banner</a>
                <div class="dg-btns btn-right">
                    <button type="submit" class="save" name="save">Save</button>
                </div>
            </div>
        </div>

        <!-- Mobile Banner Section -->
        <div class="rps">
            <h3>Home Page Slider For Mobile</h3>
            <div class="inn">
                <div id="mobile-banner-container">
                    <?php
                    $mobile_banner_ids = isset($home_page_data['mobile_banner']) && is_array($home_page_data['mobile_banner']) ? $home_page_data['mobile_banner'] : [];
                    if (empty($mobile_banner_ids)) {
                        $mobile_banner_ids[] = 0;
                    }
                    foreach ($mobile_banner_ids as $banner) : ?>
                        <div class="inp input-group">
                            <div class="img">
                                <p><strong>Preferred Image Size: 400 x 400</strong></p>
                                <div class="up_img" style="width: 200px;">
                                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                    <img src="<?php echo $banner ? esc_url(wp_get_attachment_url($banner)) : get_template_directory_uri() . '/admin/assets/img/trans.png'; ?>" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                    <a href="#" class="button rudr-upload">Upload image</a>
                                    <input type="hidden" name="mobile_banner[]" value="<?php echo esc_attr($banner); ?>">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <div class="inp input-group template" style="display:none;">
                        <div class="img">
                            <p><strong>Preferred Image Size: 400 x 400</strong></p>
                            <div class="up_img" style="width: 200px;">
                                <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                <a href="#" class="button rudr-upload">Upload image</a>
                                <input type="hidden" name="mobile_banner[]" value="">
                            </div>
                        </div>
                    </div>
                </div>
                <a href="#" class="dgh-add-row-mobile dg-btn" style="float:left;">+ Add Mobile Banner</a>
                <div class="dg-btns btn-right">
                    <button type="submit" class="save" name="save">Save</button>
                </div>
            </div>
        </div>

        <div class="rps">
            <h3>Offers</h3>
            <div class="inn" id="offer-container">
                <?php foreach ($offer_data as $index => $offer): ?>
                    <div class="offer-block">
                        <h3>Offer #<?php echo $index + 1; ?></h3>
                        <a href="#" class="del-offer button">Remove</a>
                        <div class="inp input-group">
                            <label><strong>Icon Image:</strong></label>
                            <div class="img" style="width: 300px; flex:0;">
                                <p><strong>Image Size: 50 x 50</strong></p>
                                <div class="img up_img">
                                    <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                                    <img src="<?php echo !empty($offer['iconimage']) ? esc_url(wp_get_attachment_url($offer['iconimage'])) : get_template_directory_uri() . '/admin/assets/img/trans.png'; ?>" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                                    <a href="#" class="button rudr-upload">Upload image</a>
                                    <input type="hidden" name="iconimage[]" value="<?php echo esc_attr($offer['iconimage']); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="inp input-group">
                            <label><strong>Offer Title:</strong></label>
                            <input type="text" name="offer_title[]" value="<?php echo esc_attr($offer['offer_title']); ?>">
                        </div>
                        <div class="inp input-group">
                            <label><strong>Description:</strong></label>
                            <textarea name="offer_description[]" rows="4"><?php echo esc_textarea($offer['offer_description']); ?></textarea>
                        </div>
                        <hr>
                    </div>
                <?php endforeach; ?>

                <!-- Template -->
                <div class="offer-block template" style="display:none;">
                    <a href="#" class="del-offer button">Remove</a>
                    <div class="inp input-group">
                        <label><strong>Icon Image:</strong></label>
                        <div class="img up_img" style="width: 300px;">
                            <a href="#" class="rudr-remove button dashicons dashicons-trash"></a>
                            <img src="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png" data-def="<?php echo get_template_directory_uri(); ?>/admin/assets/img/trans.png">
                            <a href="#" class="button rudr-upload">Upload image</a>
                            <input type="hidden" name="iconimage[]" value="">
                        </div>
                    </div>
                    <div class="inp input-group">
                        <label><strong>Offer Title:</strong></label>
                        <input type="text" name="offer_title[]" value="">
                    </div>
                    <div class="inp input-group">
                        <label><strong>Description:</strong></label>
                        <textarea name="offer_description[]" rows="4"></textarea>
                    </div>
                    <hr>
                </div>

                <a href="#" id="add-offer" class="dgh-add-row dg-btn">+ Add Offer</a>
                <div class="dg-btns btn-right">
                    <button type="submit" class="save" name="save">Save</button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Banner image logic
    document.querySelectorAll('.rudr-upload').forEach(initMediaUpload);

    document.querySelectorAll('.rudr-remove').forEach(btn => {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            // Remove the closest input group or up_img container
            let group = btn.closest('.inp.input-group');
            if (!group) group = btn.closest('.img.up_img');
            if (group) group.remove();
        });
    });

    // Desktop Banner Add
    const addDesktopBannerBtn = document.querySelector('.dgh-add-row-desktop');
    if (addDesktopBannerBtn) {
        addDesktopBannerBtn.addEventListener('click', function (e) {
            e.preventDefault();
            const template = document.querySelector('#banner-container .input-group.template');
            if (!template) return;
            const clone = template.cloneNode(true);
            clone.classList.remove('template');
            clone.style.display = 'block';
            clone.querySelector('input[type="hidden"]').value = '';
            clone.querySelector('img').src = clone.querySelector('img').getAttribute('data-def');
            document.getElementById('banner-container').appendChild(clone);
            initMediaUpload(clone.querySelector('.rudr-upload'));
            clone.querySelector('.rudr-remove').addEventListener('click', function (e) {
                e.preventDefault();
                clone.remove();
            });
        });
    }

    // Mobile Banner Add
    const addMobileBannerBtn = document.querySelector('.dgh-add-row-mobile');
    if (addMobileBannerBtn) {
        addMobileBannerBtn.addEventListener('click', function (e) {
            e.preventDefault();
            const template = document.querySelector('#mobile-banner-container .input-group.template');
            if (!template) return;
            const clone = template.cloneNode(true);
            clone.classList.remove('template');
            clone.style.display = 'block';
            clone.querySelector('input[type="hidden"]').value = '';
            clone.querySelector('img').src = clone.querySelector('img').getAttribute('data-def');
            document.getElementById('mobile-banner-container').appendChild(clone);
            initMediaUpload(clone.querySelector('.rudr-upload'));
            clone.querySelector('.rudr-remove').addEventListener('click', function (e) {
                e.preventDefault();
                clone.remove();
            });
        });
    }

    // Offer logic
    const addOfferBtn = document.getElementById('add-offer');
    if (addOfferBtn) {
        addOfferBtn.addEventListener('click', function (e) {
            e.preventDefault();
            const container = document.getElementById('offer-container');
            if (!container) return;
            const template = container.querySelector('.offer-block.template');
            if (!template) return;
            const clone = template.cloneNode(true);
            clone.classList.remove('template');
            clone.style.display = 'block';
            clone.querySelectorAll('input, textarea').forEach(field => field.value = '');
            clone.querySelector('img').src = clone.querySelector('img').getAttribute('data-def');
            container.insertBefore(clone, addOfferBtn);
            initMediaUpload(clone.querySelector('.rudr-upload'));
            clone.querySelector('.del-offer').addEventListener('click', function (e) {
                e.preventDefault();
                clone.remove();
            });
        });
    }

    document.getElementById('offer-container').addEventListener('click', function (e) {
        if (e.target.classList.contains('del-offer')) {
            e.preventDefault();
            e.target.closest('.offer-block').remove();
        }
    });

    function initMediaUpload(button) {
        if (!button) return;
        button.addEventListener('click', function (e) {
            e.preventDefault();
            const wrapper = button.closest('.up_img');
            const img = wrapper.querySelector('img');
            const input = wrapper.querySelector('input[type="hidden"]');

            if (typeof wp === 'undefined' || !wp.media) {
                alert('WordPress media uploader not available.');
                return;
            }

            const file_frame = wp.media({
                title: 'Select or Upload Image',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            });

            file_frame.on('select', function () {
                const attachment = file_frame.state().get('selection').first().toJSON();
                img.src = attachment.url;
                input.value = attachment.id;
            });

            file_frame.open();
        });
    }
});
</script>

<!-- CSS -->
<style>
    #banner-container {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 20px;
    }
    #mobile-banner-container {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 20px;
    }

    .rps {
        background-color: #fbfbfb;
        margin-bottom: 25px;
        border-radius: 10px;
    }

    .inn {
        padding: 20px;
    }

    .rps h3 {
        background: linear-gradient(to right, rgb(225, 225, 225), rgb(255, 214, 182));
        padding: 10px;
        border-radius: 10px 10px 0 0;
        color: black;
        text-align: center;
    }

    .inp {
        border-bottom: none;
    }

    .input-group {
        display: flex;
        align-items: center;
        gap: 20px;
        margin-bottom: 20px;
        flex-wrap: wrap;
    }

    .input-group label {
        width: 200px;
        font-weight: bold;
        text-align: left;
    }

    .input-group input,
    .input-group textarea {
        flex: 1;
        min-width: 250px;
        padding: 8px;
        border: 1px solid #ccc;
        border-radius: 4px;
        width: 100%;
    }

    .up_img {
        width: 300px;
        height: 150px;
        border: 1px solid #666;
        padding: 5px;
        text-align: center;
        position: relative;
    }

    .up_img img {
        width: 100%;
        height: 120px;
        object-fit: cover;
    }

    .dg-btns {
        text-align: right;
        margin-top: 20px;
    }
</style>