<?php
// Delete project if "del" is set
if (isset($_GET["del"])) {
    $del_id = intval($_GET["del"]);
    if (get_post_type($del_id) === 'project') {
        wp_delete_post($del_id, true); // Force delete
        echo '<div class="notice notice-success"><p>Project deleted successfully.</p></div>';
    } else {
        echo '<div class="notice notice-error"><p>Invalid project ID.</p></div>';
    }
}

// Fetch all project posts
$projects = get_posts([
    'post_type' => 'project',
    'posts_per_page' => -1,
    'post_status' => 'publish'
]);

$admin_page_url = admin_url('admin.php?page=project-list'); // Change if your page slug is different
$add_page_url = admin_url('admin.php?page=project-add');     // Change if your add/edit page slug is different
?>

<div class="dg-btns btn-right" style="position: absolute;right:20px;top:17px">
    <a href="?page=smecon-settings&pg=project-add" class="dg-btn">Add Project</a>
</div>

<table class="dg-table" style="margin-top: 20px;">
    <thead>
        <tr>
            <th style="width: 40px;">Sr.</th>
            <th style="text-align: left;">Project Name</th>
            <th style="width: 200px;">Status</th>
            <th style="width: 200px;">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($projects)) :
            $sr = 1;
            foreach ($projects as $project) :
                $title = esc_html($project->post_title);
                $status = get_post_meta($project->ID, 'project_status', true) ?: 'in-hand';
        ?>
                <tr>
                    <td><?php echo $sr++; ?></td>
                    <td style="text-align: left;"><?php echo $title; ?></td>
                    <td style="font-weight:500;color:brown"><?php echo ucfirst(esc_html($status)); ?></td>
                    <td>
                        <a href="?page=smecon-settings&pg=project-add&i=<?php echo $project->ID; ?>" class="edit-btn">
                            <span class="dashicons dashicons-edit"></span>
                        </a>

                        <a href="?page=smecon-settings&pg=projects&del=<?php echo $project->ID; ?>" class="_del_href delete-btn">
                            <span class="dashicons dashicons-trash"></span>
                        </a>
                    </td>
                </tr>
            <?php endforeach;
        else : ?>
            <tr>
                <td colspan="4">No projects found.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<style>
    .dg-btn {
        border: 1px solid whitesmoke;
        transition: all 0.5s ease-in-out;
        padding: 8px 20px;
        background-color: #e28413;
        color: white;
        border-radius: 4px;
        font-weight: 600;
    }

    .dg-btn:hover {
        background-color: whitesmoke;
        color: black;
    }

    .btn {
        padding: 5px 10px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        text-decoration: none;
        color: white;
    }

    .edit-btn {
        background-color: #007bff;
        padding: 5px 8px;
        border-radius: 4px;
        color: white;
        margin-right: 5px;
        text-decoration: none;
    }

    .delete-btn {
        background-color: #dc3545;
        padding: 5px 8px;
        border-radius: 4px;
        color: white;
        text-decoration: none;
    }

    .edit-btn:hover,
    .delete-btn:hover {
        opacity: 0.85;
    }

    .dg-table {
        width: 100%;
        border-collapse: collapse;
    }

    .dg-table th,
    .dg-table td {
        padding: 10px;
        border: 1px solid #ddd;
    }

    .dg-table thead {
        background-color: #f2f2f2;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const delLinks = document.querySelectorAll('._del_href');
        delLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm('Are you sure you want to delete this project?')) {
                    e.preventDefault();
                }
            });
        });
    });
</script>