<?php include "components/header.php"; ?>

<style>
    body {
        font-family: Arial, sans-serif;
        scroll-behavior: smooth;
        /* overflow-y: scroll; */
    }

    .main-content {
        margin: 20px 0;
    }

    .project-detail {
        padding: 50px 0;
    }

    .project-detail h2,
    .project-detail h3 {
        font-weight: 700;
    }

    .project-detail h2 {
        font-size: 1.6rem;
        margin-bottom: 20px;
    }

    .project-detail h3 {
        font-size: 24px;
        margin-bottom: 15px;
        margin-top: 0;
    }

    .project-detail p,
    .project-detail ul li,
    .project-detail ol li {
        font-size: 16px;
        line-height: 1.7;
    }

    .project-detail ul {
        padding-left: 20px;
        margin-bottom: 20px;
    }

    .project-detail ul li {
        margin-bottom: 10px;
        list-style-type: none;
    }

    .left-side {
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .right-side {
        padding: 0;
        border-radius: 10px;
        /* box-shadow: 0 0 15px rgba(0, 0, 0, 0.1); */
        height: fit-content;
    }

    .progress {
        height: 1.5rem;
        border-radius: 5px;
    }

    .progress-bar {
        font-size: 16px;
        font-weight: 700;
        padding: 10px;
        background-color: var(--site-color);
    }

    .carousel-item img {
        width: 100%;
        height: 400px;
        object-fit: cover;
        border-radius: 5px;
    }

    .carousel-control-prev,
    i.fa-chevron-left,
    .carousel-control-next,
    i.fa-chevron-right {
        font-size: 24px;
        width: 5%;
        border-radius: 5px;
        color: var(--site-color);
        padding: 5px 10px;

    }

    .carousel-control-prev-icon .fa-chevron-left {
        font-size: 24px;
        width: 5%;
        border-radius: 5px;
        color: var(--site-color);
        padding: 5px 10px;
    }

    .col-md-9 {
        flex: 0 0 73% !important;
        max-width: 73% !important;
    }

    #project-slider {
        margin: 20px auto;
    }


    .srch-btn {
        background-color: var(--site-color);
        color: #fff;
        border: none;
        padding: 7px 15px;
        border-radius: 0px 5px 5px 0px;
        cursor: pointer;
    }

    .srch {
        margin-bottom: 20px;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .more-project {
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .stroke-shape {
        position: relative;
        width: 100px;
        height: 4px;
        border-radius: 30px;
        background: linear-gradient(270deg, black 0, var(--site-color) 100%);
        margin: 0px 0px 20px 0px;
    }

    .card-text ul {
        list-style: none;
        padding: 0;
        margin-bottom: 10px;
    }

    .card-text ul li {
        line-height: 30px;
        font-size: 1rem;
        list-style-type: none
    }

    .card-text ul li span {
        font-weight: bold;
        color: var(--site-color);
        font-family: monospace;
    }

    .card-text ul li span i {
        margin-right: 5px;
        color: #002c42;
    }

    .more-project ul li a {
        padding: 0px 4px;
    }

    /* .more-project ul li .com {
    float: right;
    color: #fff;
    padding: 5px;
    font-weight: bold;
    border-radius: 2px;
    background-color: var(--site-color);
    font-size: 10px;
} */
    /* .more-project ul li .pen {
    float: right;
    color: #fff;
    padding: 5px;
    font-weight: bold;
    border-radius: 2px;
    background-color: #ff0000;
    font-size: 10px;
} */


    /* ============== */

    /* TOC Container */
    .tb-content {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 8px;
        border-left: 4px solid var(--site-color);
        /* max-width: 500px; */
        margin: 20px auto;
    }

    /* TOC Heading */
    .tb-content legend {
        font-size: 18px;
        font-weight: bold;
        color: #fff;
        background: var(--site-color);
        padding: 6px 12px;
        border-radius: 4px;
    }

    /* TOC List */
    .tb-content ol {
        list-style: none;
        padding-left: 10px;
    }



    /* Links */
    .tb-content a {
        text-decoration: none;
        color: var(--site-color);
        padding: 5px 8px;
        display: block;
        transition: 0.2s;
    }

    /* Hover Effect */
    .tb-content a:hover {
        /* background:rgb(224, 245, 255); */
        color: #333;
        border-radius: 4px;
    }

    .tb-content ol {
        list-style: none;
        padding-left: 0;
    }

    .tb-content ol li {
        padding-left: 0
    }

    .tb-content li {
        margin: 8px 0;
        font-size: 15px;
        position: relative;
        padding-left: 3px;
    }

    .tb-content li::before {
        content: "\2022";
        /* Unicode for bullet point */
        color: var(--site-color);
        font-size: 20px;
        position: absolute;
        left: 0;
        top: 0;
    }

    .tb-content ol {
        counter-reset: item;
    }



    .tb-content ol ol {
        counter-reset: subitem;
    }

    .tb-content ol ol>li {
        counter-increment: subitem;
        position: relative;
        padding-left: 10px;
    }

    .tb-content ol ol>li::before {
        content: counter(item) "." counter(subitem) " ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -25px;
    }

    .tb-content ol ol ol {
        counter-reset: subsubitem;
    }

    .tb-content ol ol ol>li {
        counter-increment: subsubitem;
        position: relative;
        padding-left: 25px;
    }

    .tb-content ol ol ol>li::before {
        content: counter(item) "." counter(subitem) "." counter(subsubitem) " ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -25px;
    }




    /* Responsive */
    @media (max-width: 600px) {
        .tb-content {
            max-width: 100%;
            padding: 10px;
        }
    }

    .related-blogs ul {
        padding: 0;
    }

    .related-blogs ul li {
        list-style-type: none;
        margin-bottom: 10px;
        display: flex;
        align-items: center;
        justify-content: flex-start;
    }

    .related-blogs ul li img {
        width: 50px;
        height: 50px;
        border-radius: 5px;
        margin-right: 10px;
    }

    .related-blogs ul li a {
        font-size: .8rem;
        color: var(--site-color);
        text-decoration: none;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;

    }

    .related-blogs ul li a:hover {
        text-decoration: underline;
    }

    .related-blogs h3 {
        font-size: 24px;
        margin-bottom: 20px;
    }

    .project-detail ul li::before {
        content: "\2713";
        /* Unicode for check mark */
        color: var(--site-color);
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-right: 0.5em;
    }

    .project-detail ol {
        counter-reset: item;
        padding-left: 40px;
    }

    .project-detail ol li {
        counter-increment: item;
        margin-bottom: 10px;
        position: relative;
        list-style-type: none;
    }

    .project-detail ol li::before {
        content: counter(item) ". ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -21px;
        /* Adjust as needed */
    }

    .project-detail ul li:hover,
    .project-detail ol li:hover {
        /* background-color: rgba(0, 0, 0, 0.05); */
        cursor: pointer;
    }

    .project-detail ul li:hover::before,
    .project-detail ol li:hover::before {
        color: #333;
        /* Change the color on hover */
    }

    /* aside ol li::before,
.tb-content ol li::before {
    content: none;
} */
    .more-project ul li::before {
        content: none;
    }

    .left-side h1 {
        font-size: 1.6rem;
    }

    /* h2, h3, h4, h5, h6 {
    color: #333;
    margin-top: 20px;
    margin-bottom: 10px;
} */
    .serr ul {
        padding-left: 0;
    }

    .serr ul li {
        margin-bottom: 0px;
        list-style-type: none;
        border-bottom: 1px solid #e9e9e9;
        padding: 5px;
        transition: all 0.45s cubic-bezier(.65, 0, .076, 1);
    }

    .serr ul li:hover {
        background-color: wheat;
    }


    @media (max-width: 991px) {
        .right-side {
            display: none;
        }
    }
</style>

<div class="main-content">
    <section class="page-title tm-page-title text-left flip text-default page-title-split" style=" background-image: url(./assets/images/bb.png); ">
        <div class="container padding-extra-large">
            <div class="row">
            </div>
        </div>
    </section>

    <section class="project-detail">
        <div class="container">
            <div class="row" style="justify-content: space-between;">
                <div class="col-lg-9 col-md-12 left-side">
                    <h1>Health & Wellness: Ensuring the Well-being of Our Community Members (h1)</h1>
                    <hr>

                    <p><strong>Lorem ipsum dolor</strong> sit amet consectetur, adipisicing elit. Id veniam officiis, tempore laboriosam, dicta vero incidunt facere sequi pariatur repellendus molestiae cumque, asperiores animi ad iure voluptatem doloribus fugit perferendis.</p>
                    <img src="assets/images/safe1.jpg" alt="Project Image" style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">
                    <p><i>Lorem, ipsum dolor sit amet consectetur adipisicing elit.</i> Culpa laboriosam, consequuntur exercitationem non itaque id aperiam tenetur nam, quia consectetur repudiandae suscipit quas minus autem, sit magni ipsa officiis corrupti.</p>
                    <h2>Key Features (h2)</h2>
                    <ul>
                        <li>Construction of new roads and bridges</li>
                        <li>Development of public facilities</li>
                        <li>Enhancement of transportation networks</li>
                    </ul>
                    <h2>Health & Wellness (h2)</h2>
                    <p>Our <a href="#">Health & Wellness</a> blog covers a wide range of topics to help you live a healthier and happier life. From nutrition tips to mental health advice, we have it all. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Voluptate odio quibusdam ipsum esse cum quis corporis? Aliquid error sit voluptatum saepe dolore ducimus tempore. Est quod vel error aspernatur tenetur.</p>
                    <div>



                        <h3 id="nutrition">Nutrition (h3)</h3>
                        <p>Proper nutrition is essential for maintaining good health. Here are some tips to help you eat better: Lorem ipsum dolor sit amet consectetur adipisicing elit. Eveniet, esse excepturi! Alias sed facilis mollitia temporibus in nisi nulla, officiis itaque, a commodi iusto id, pariatur adipisci ipsa corrupti expedita!</p>
                        <ol>
                            <li>Eat a variety of foods</li>
                            <li>Include plenty of fruits and vegetables</li>
                            <li>Stay hydrated</li>
                        </ol>
                        <img src="assets/images/safe2.jpg" alt="Nutrition Image" style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">

                        <h3 id="exercise">Exercise (h3)</h3>
                        <p>Regular exercise is crucial for staying fit and healthy. Here are some exercises you can try: Lorem ipsum dolor sit amet consectetur adipisicing elit. Consequuntur voluptates quod possimus dolore at autem optio, consequatur corrupti sapiente nam porro velit qui, nihil labore, veniam ullam minima eaque officia! </p>
                        <ul>
                            <li>Cardio exercises like running and cycling</li>
                            <li>Strength training exercises</li>
                            <li>Flexibility exercises like yoga</li>
                        </ul>
                        <img src="assets/images/safe3.jpg" alt="Exercise Image" style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">

                        <h4 id="mental-health">Mental Health (h4)</h4>
                        <p>Mental health is just as important as physical health. Here are some tips to improve your mental well-being: Lorem, ipsum dolor sit amet consectetur adipisicing elit. Repellendus aliquam dolor ea assumenda voluptates deleniti sed, architecto atque totam ullam quasi repudiandae qui, rerum placeat ipsum delectus, laboriosam natus quam!</p>
                        <ol>
                            <li>Practice mindfulness and meditation</li>
                            <li>Stay connected with loved ones</li>
                            <li>Seek professional help if needed</li>
                        </ol>
                        <img src="assets/images/safe4.jpg" alt="Mental Health Image" style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">

                        <h4 id="wellness-tips">Wellness Tips (h4)</h4>
                        <p>Here are some additional tips to help you stay well: Lorem ipsum dolor, sit amet consectetur adipisicing elit. Optio libero perferendis, quis ipsa repellendus, sint nostrum commodi quam odio neque eos blanditiis sed corrupti! Id mollitia tempore sint veritatis. Corporis.</p>
                        <ul>
                            <li>Get enough sleep</li>
                            <li>Manage stress effectively</li>
                            <li>Maintain a positive outlook</li>
                        </ul>
                        <img src="assets/images/safe4.jpg" alt="Wellness Tips Image" style="width: 100%; height: auto; border-radius: 10px; margin-bottom: 20px;">

                        <h5>Watch Our Latest Video (h5)</h5>
                        <p>Lorem ipsum dolor sit amet consectetur, adipisicing elit. Est expedita nostrum ea dolore voluptatibus eveniet deleniti pariatur, recusandae placeat explicabo commodi ipsa temporibus, soluta quis officia voluptatum? Id, magnam corrupti.</p>
                        <div style="position: relative; padding-bottom: 56.25%; height: 0; overflow: hidden; max-width: 100%; height: auto; margin-bottom: 30px; border-radius: 8px;">
                            <iframe src="https://www.youtube.com/embed/aWAak3f_D2s?si=EBQKQ6QtbapiIjHg" frameborder="0" allowfullscreen style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;"></iframe>
                        </div>
                        <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Porro voluptas laudantium dolorum distinctio ipsa aperiam voluptatum dolores quis adipisci, rerum optio eos cupiditate deserunt modi hic, iusto eius facilis sit.</p>
                        <h6>Conclusion (h6)</h6>
                        <p>In conclusion, the San Francisco Project to the Pakistan-Afghanistan border is a significant initiative aimed at improving infrastructure and public facilities. The project focuses on constructing new roads and bridges, developing public facilities, and enhancing transportation networks. Additionally, our Health & Wellness blog provides valuable tips on nutrition, exercise, mental health, and overall wellness to help you lead a healthier life.</p>
                        <p>Stay tuned for more updates and related blogs on our website. Thank you for reading!</p>
                    </div>
                </div>

                <aside class="col-lg-3 right-side">
                    <div class="srch mb-4">
                        <form style="position: relative;">
                            <div class="form-group" style="margin-bottom: 0;">
                                <!-- <label for="search">Serach</label><br> -->
                                <input type="text" name="query" class="form-control" placeholder="Search Blogs...">
                            </div>
                            <button style="position: absolute; top: 0; right: 0;" type="submit" class="srch-btn">
                                <i class="fas fa-search"></i>
                            </button>
                        </form>
                    </div>
                    <div class="related-blogs more-project mb-4">
                        <h3>Related Blogs</h3>
                        <div class="stroke-shape"></div>
                        <ul>
                            <li>
                                <img src="assets/images/safe1.jpg" alt="Blog Image" style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                <a href="#">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aut laboriosam magni et placeat unde, neque repellendus aspernatur, magnam commodi eius accusantium, impedit sit repudiandae reprehenderit inventore quo. Saepe, tempora ratione.</a>
                            </li>
                            <li>
                                <img src="assets/images/safe1.jpg" alt="Blog Image" style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                <a href="#">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aut laboriosam magni et placeat unde, neque repellendus aspernatur, magnam commodi eius accusantium, impedit sit repudiandae reprehenderit inventore quo. Saepe, tempora ratione.</a>
                            </li>
                            <li>
                                <img src="assets/images/safe1.jpg" alt="Blog Image" style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                <a href="#">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aut laboriosam magni et placeat unde, neque repellendus aspernatur, magnam commodi eius accusantium, impedit sit repudiandae reprehenderit inventore quo. Saepe, tempora ratione.</a>
                            </li>
                            <li>
                                <img src="assets/images/safe3.jpg" alt="Blog Image" style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                <a href="#">Blog Title 3</a>
                            </li>
                        </ul>
                    </div>
                    <div class="more-project mb-4 serr" style="width: 300px;">
                        <h3>Our Services</h3>
                        <div class="stroke-shape"></div>
                        <ul>
                            <li><a href="#">Web Development</a></li>
                            <li><a href="#">Mobile App Development</a></li>
                            <li><a href="#">Digital Marketing</a></li>
                            <li><a href="#">SEO Services</a></li>
                            <li><a href="#">Graphic Design</a></li>
                        </ul>
                    </div>
                    <style>
                        .serr {
                            background: #fff;
                            padding: 20px;
                            border-radius: 10px;
                            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
                            transition: all 0.3s ease-in-out;
                            width: 300px;
                        }



                        .serr ul {
                            list-style: none;
                            padding: 0;
                        }

                        .serr ul li {
                            display: flex;
                            align-items: center;
                            padding: 10px 15px;
                            border-radius: 5px;
                            background: #f8f9fa;
                            margin-bottom: 8px;
                            transition: all 0.3s ease-in-out;
                        }

                        .serr ul li:hover {
                            background: var(--site-color);
                            transform: translateX(5px);
                        }

                        .serr ul li a {
                            text-decoration: none;
                            color: #333;
                            font-weight: 500;
                            font-size: 16px;
                            transition: color 0.3s ease-in-out;
                            flex-grow: 1;
                        }

                        .serr ul li:hover a {
                            color: #fff;
                        }

                        .serr ul li::before {
                            content: "✔";
                            /* Tick icon */
                            font-size: 16px;
                            color: var(--site-color);
                            margin-right: 10px;
                        }

                        .serr ul li:hover::before {
                            color: #fff;
                        }
                    </style>
                    <script>
                        window.addEventListener("scroll", function() {
                            let aside = document.querySelector(".right-side");
                            let leftSide = document.querySelector(".left-side"); // Left section ko select karein
                            let lastChild = aside.querySelector(".serr"); // Directly select .serr
                            let scrollY = window.scrollY;
                            let leftHeight = leftSide.offsetHeight; // Left section ki height

                            if (scrollY > 1000 && scrollY < leftHeight) {
                                lastChild.style.position = "fixed";
                                lastChild.style.top = "20px";
                            } else {
                                lastChild.style.position = "relative";
                            }
                        });
                    </script>
                </aside>
            </div>
        </div>
    </section>
</div>


<?php include "components/footer.php"; ?>