<!-- foooter ======================================== -->

<div id="back-to-top" class="element-3">
	<div class="c-subscribe-box u-align-center">
		<div class="rainbow">
			<span></span>
			<span></span>
		</div>
		<div class="c-subscribe-box__wrapper">
			<span>
				<i class="fa-solid fa-arrow-up-long" title="Go top"></i>
			</span>
		</div>
	</div>
</div>

<style>
	#back-to-top {
		position: fixed;
		right: -150px;
		bottom: 50px;
		z-index: 99;
		width: 40px;
		height: 40px;
		text-align: center;
		line-height: 38px;
		-webkit-border-radius: 50%;
		-moz-border-radius: 50%;
		border-radius: 50%;
		background-color: #fff;
		-webkit-box-shadow: 0 10px 40px rgb(82 85 90 / 20%);
		-moz-box-shadow: 0 10px 40px rgba(82, 85, 90, .2);
		box-shadow: 0 10px 40px rgb(82 85 90 / 20%);
		color: var(--site-color);
		font-size: 16px;
		-webkit-transition: all .4s;
		-moz-transition: all .4s;
		-ms-transition: all .4s;
		-o-transition: all .4s;
		transition: all .4s;
		cursor: pointer;
		opacity: 0;
		visibility: hidden;
	}

	.element-3 {
		background: linear-gradient(135deg, rgba(0, 0, 0, .22), rgba(255, 255, 255, .25));
	}

	#back-to-top .c-subscribe-box {
		border-radius: 100%;
	}

	.c-subscribe-box {
		overflow: hidden;
		position: relative;
		box-shadow: 0 10px 40px -10px rgba(0, 64, 128, .2);
		border-radius: 8px;
		width: 100%;
		height: 100%;
	}

	#back-to-top .rainbow {
		top: -2px;
		width: 50px;
		height: 50px;
	}

	.rainbow {
		position: absolute;
		top: -25px;
		width: 200px;
		height: 100px;
		-webkit-animation: o-rotate-360linear 8s infinite;
		animation: o-rotate-360linear 8s infinite;
	}

	@keyframes o-rotate-360linear {
		0% {
			transform: rotate(0deg);
		}

		100% {
			transform: rotate(360deg);
		}
	}

	.rainbow span:first-child {
		background: #65587f;
	}

	.rainbow span:last-child:after {
		background: #50bda1;
	}

	.rainbow span:first-child {
		background: #65587f
	}

	.rainbow span:first-child:after {
		background: #f18867
	}

	.rainbow span:last-child {
		background: #e85f99
	}

	.rainbow span {
		display: block;
		width: 100%;
		height: 100%;
		position: relative;
		transform: translate(-50%, -50%);
	}

	.rainbow span:after {
		display: block;
		content: "";
		width: 100%;
		height: 100%;
		position: absolute;
		left: 100%;
	}

	#back-to-top .c-subscribe-box__wrapper {
		width: 30px;
		height: 30px;
		border-radius: 100%;
	}

	.c-subscribe-box__wrapper {
		width: 190px;
		height: 50px;
		position: absolute;
		top: 50%;
		left: 50%;
		transform: translate(-50%, -50%);
		display: flex;
		align-items: center;
		justify-content: center;
		border-radius: 4px;
		background: #fff;
	}

	.c-subscribe-box__wrapper span {
		color: var(--site-color);
		font-size: 20px;
		font-weight: 700;
	}

	#back-to-top:hover {
		background-color: var(--site-color);
		color: #fff;
		-webkit-transform: scale(1.1);
		-moz-transform: scale(1.1);
		-ms-transform: scale(1.1);
		-o-transform: scale(1.1);
		transform: scale(1.1);
	}

	#back-to-top.btn-active {
		right: 30px;
		opacity: 1;
		visibility: visible !important;
	}
</style>

<script>
	document.addEventListener("DOMContentLoaded", function() {
		var backToTopButton = document.getElementById("back-to-top");

		window.addEventListener("scroll", function() {
			if (window.scrollY > 300) {
				backToTopButton.classList.add("btn-active");
			} else {
				backToTopButton.classList.remove("btn-active");
			}
		});

		backToTopButton.addEventListener("click", function(e) {
			e.preventDefault();
			window.scrollTo({
				top: 0,
				behavior: "smooth"
			});
		});
	});
</script>

<footer id="footer" class="footer " style="margin-top: 2px;">
	<div class="footer-widget-area">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div data-vc-full-width="true" data-vc-full-width-init="true" class="vc_row wpb_row vc_row-fluid vc_custom_1567246333201 vc_row-has-fill vc-row-tm-section-padding vc-row-tm-parent-section ult-vc-hide-row">
						<div class="upb_row_bg vcpb-default"></div>
						<div class="wpb_column vc_column_container vc_col-sm-12">
							<div class="vc_column-inner vc_custom_1566815983760">
								<div class="wpb_wrapper">
									<div class="vc_row wpb_row vc_inner vc_row-fluid vc_custom_1567223103192 vc_row-o-equal-height vc_row-flex">
										<div class="wpb_column vc_column_container vc_col-sm-6 vc_col-md-3">
											<div class="vc_column-inner">
												<div class="wpb_wrapper">
													<div class="wpb_widgetised_column wpb_content_element">
														<div class="wpb_wrapper">
															<div id="tm_widget_contact_info-1" class="widget widget-contact-info clearfix">
																<?php
																$settings = get_option('lga_settings');
																$logo_id = isset($settings['logo']) ? $settings['logo'] : '';
																$logo_url = !empty($logo_id) ? wp_get_attachment_image_url($logo_id, 'full') : get_template_directory_uri() . '/assets/images/logo.png';

																$footer_short_info = isset($settings['footer_short_info']) ? $settings['footer_short_info'] : '1-B, 2nd Floor, Lahore Center Main Boulevard, 77-D/1, Gullberg-III Lahore - Pakistan';

																$contact_number = isset($settings['contact_number']) ? $settings['contact_number'] : '+92-320-2345678';
																$contact_email = isset($settings['contact_email']) ? $settings['contact_email'] : 'info@example.com';
																$website = isset($settings['footer_website']) ? $settings['footer_website'] : home_url();

																$facebook  = !empty($settings['facebook']) ? $settings['facebook'] : '#';
																$instagram = !empty($settings['instagram']) ? $settings['instagram'] : '#';
																$linkedin  = !empty($settings['linkedin']) ? $settings['linkedin'] : '#';
																$youtube   = !empty($settings['youtube']) ? $settings['youtube'] : '#';
																?>

																<div class="tm-widget tm-widget-contact-info contact-info contact-info-style1 contact-icon-theme-colored1">
																	<div class="thumb">
																		<img alt="Logo" src="<?php echo esc_url($logo_url); ?>">
																	</div>
																	<div class="description"><?php echo esc_html($footer_short_info); ?></div>
																	<ul>
																		<li class="contact-phone">
																			<div class="icon"><i class="fa fa-phone"></i></div>
																			<div class="text"><a href="tel:<?php echo esc_attr($contact_number); ?>"><?php echo esc_html($contact_number); ?></a></div>
																		</li>

																		<li class="contact-email">
																			<div class="icon"><i class="fa fa-envelope"></i></div>
																			<div class="text"><a href="mailto:<?php echo esc_attr($contact_email); ?>"><?php echo esc_html($contact_email); ?></a></div>
																		</li>

																		<li class="contact-website">
																			<div class="icon"><i class="fa fa-globe"></i></div>
																			<div class="text"><a target="_blank" href="<?php echo esc_url($website); ?>"><?php echo esc_html(str_replace(['http://', 'https://'], '', $website)); ?></a></div>
																		</li>
																	</ul>
																</div>

															</div>
															<div id="tm_widget_social_list-1" class="widget widget-social-icons clearfix">
																<ul class="tm-widget tm-widget-social-list tm-widget-social-list-brand styled-icons styled-icons-brand icon-rounded">
																	<?php if ($facebook): ?>
																		<li>
																			<a class="social-link styled-icons-item" data-tm-bg-color="#3B5998" href="<?php echo esc_url($facebook); ?>" target="_blank" aria-label="Facebook" style="background: #3B5998;">
																				<i class="fa-brands fa-facebook"></i>
																			</a>
																		</li>
																	<?php endif; ?>

																	<?php if ($instagram): ?>
																		<li>
																			<a class="social-link styled-icons-item" data-tm-bg-color="#E2002B" href="<?php echo esc_url($instagram); ?>" target="_blank" aria-label="Instagram" style="background: #E2002B;">
																				<i class="fa-brands fa-instagram"></i>
																			</a>
																		</li>
																	<?php endif; ?>

																	<?php if ($linkedin): ?>
																		<li>
																			<a class="social-link styled-icons-item" data-tm-bg-color="#007BB6" href="<?php echo esc_url($linkedin); ?>" target="_blank" aria-label="LinkedIn" style="background: #007BB6;">
																				<i class="fa-brands fa-linkedin"></i>
																			</a>
																		</li>
																	<?php endif; ?>

																	<?php if ($youtube): ?>
																		<li>
																			<a class="social-link styled-icons-item" data-tm-bg-color="#C71F1E" href="<?php echo esc_url($youtube); ?>" target="_blank" aria-label="YouTube" style="background: #C71F1E;">
																				<i class="fa-brands fa-youtube"></i>
																			</a>
																		</li>
																	<?php endif; ?>
																</ul>
															</div>
														</div>
													</div>
													<div class="vc_empty_space  d-block d-sm-none" style="height: 20px">
														<span class="vc_empty_space_inner"></span>
													</div>
												</div>
											</div>
										</div>
										<?php
											$menus = [
											'footer-col-1' => 'Updates',
											'footer-col-2' => 'Services',
											'footer-col-3' => 'Useful Links',
											];
											foreach ($menus as $location => $title): ?>
										<div class="wpb_column vc_column_container vc_col-sm-6 vc_col-md-3">
											<div class="vc_column-inner">
												<div class="wpb_wrapper">
													<div class="wpb_widgetised_column wpb_content_element">
														<div class="wpb_wrapper">
															<div id="tm_widget_blog_list-2" class="widget widget-blog-list clearfix">
																<h4 class="widget-title  line-bottom-footer-widget line-bottom-theme-colored1"><?php echo esc_html($title); ?></h4>
																<div class="tm-widget tm-widget-blog-list ">
																	<?php
																	wp_nav_menu([
																		'theme_location' => $location,
																		'menu_class' => 'menu',
																		'container' => false,
																		'fallback_cb' => false
																	]);
																	?>
																</div>
															</div>
														</div>
													</div>
													<div class="vc_empty_space  d-block d-sm-none" style="height: 20px">
														<span class="vc_empty_space_inner"></span>
													</div>
												</div>
											</div>
										</div>
										<?php endforeach; ?>
									</div>
									<div class="vc_row wpb_row vc_inner vc_row-fluid">
										<div class="wpb_column vc_column_container vc_col-sm-12">
											<div class="vc_column-inner">
												<div class="wpb_wrapper">
													<div class="vc_separator wpb_content_element vc_separator_align_center vc_sep_width_100 vc_sep_pos_align_center vc_separator_no_text">
														<span class="vc_sep_holder vc_sep_holder_l">
															<span style="border-color:#373b41;" class="vc_sep_line"></span>
														</span>
														<span class="vc_sep_holder vc_sep_holder_r">
															<span style="border-color:#373b41;" class="vc_sep_line"></span>
														</span>
													</div>
													<div class="wpb_text_column wpb_content_element ">
														<div class="wpb_wrapper">
															<p style="color: #bbbbbb; text-align: center;">
																©️ 2020 Smecon (Pvt) Ltd. All Rights Reserved. Developed by: <a href="#">Digital Applications</a></p>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="vc_row-full-width vc_clearfix"></div><!-- Row Backgrounds --> <!-- end of the loop -->
				</div>
			</div>
		</div>
	</div>
</footer>

<script>
      window.addEventListener('load', function() {
        var fa = document.createElement('link');
        fa.rel = 'stylesheet';
        fa.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css';
        document.head.appendChild(fa);
      });
    </script>
<?php wp_footer(); ?>
</body>

</html>