<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="SMECON Private Limited - Efficient Power Construction With No Boundaries">
    <meta name="keywords" content="SMECON, Power Construction, Engineering, Private Limited, Efficient Power Solutions">
    <meta name="author" content="SMECON Private Limited">
    <!-- Load CSS in order: boot.css, theme.css, slider.css -->
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/boot.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/theme.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/slider.css?v=<?php echo rand(1000, 9999); ?>">
    <!-- <link rel="stylesheet" href="/assets/css/almin.css"> -->
    <!-- <link rel="stylesheet" href="/assets/css/animate.css"> -->
    <!-- <link rel="stylesheet" href="/assets/css/flaticon.css"> -->
    <!-- Font Awesome CDN will be loaded after page load -->

    <?php
    // Get the theme options
    $settings = get_option('lga_settings');

    // Get the favicon ID from options
    $favicon_id = isset($settings['favicon']) ? $settings['favicon'] : '';

    // Get the favicon image URL
    $favicon_url = !empty($favicon_id) ? wp_get_attachment_url($favicon_id) : '';
    ?>

    <?php if (!empty($favicon_url)) : ?>
        <link rel="icon" href="<?php echo esc_url($favicon_url); ?>" type="image/x-icon">
    <?php endif; ?>


    <title>SMECON PRIVATE LIMITED</title>
    <style>
        ::-webkit-scrollbar {
            width: 10px;
            height: 10px;
        }

        ::-webkit-scrollbar-thumb {
            background: whitesmoke;
            border-radius: 16px;
            box-shadow: inset 2px 2px 2px hsla(0, 0%, 100%, .25), inset -2px -2px 2px hsla(0, 0%, 0%, .25);
        }

        ::-webkit-scrollbar-track {
            background: linear-gradient(90deg, #434343, #434343 1px, #111 0, #111);
        }

        ::selection {
            background-color: var(--site-color);
            color: #fff;
        }
    </style>

    <?php wp_head(); ?>
</head>

<body>


    <header id="header" class="header header-layout-type-header-3rows-modern-header-style1">

        <div class="header-top   header-top-curve-default">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-12 text-xl-left text-md-center text-sm-center section-typo-light">
                        <div class="element custom-text">"Efficient Power Construction With No Boundaries"</div>
                    </div>
                    <?php
                    $options = get_option('lga_settings');
                    $facebook  = isset($options['facebook']) ? $options['facebook'] : '#';
                    $youtube   = isset($options['youtube']) ? $options['youtube'] : '#';
                    $linkedin  = isset($options['linkedin']) ? $options['linkedin'] : '#';
                    $instagram = isset($options['instagram']) ? $options['instagram'] : '#';
                    ?>

                    <div class="col-lg-6 col-md-12 text-xl-right text-lg-right text-md-center text-sm-center section-typo-light">
                        <ul class="element styled-icons icon-gray icon-default icon-sm icon-theme-colored3 ibib">
                            <?php if (!empty($facebook)) : ?>
                                <li><a class="styled-icons-item" href="<?php echo esc_url($facebook); ?>" target="_blank" aria-label="Facebook"><i class="fa-brands fa-facebook-f"></i></a></li>
                            <?php endif; ?>

                            <?php if (!empty($instagram)) : ?>
                                <li><a class="styled-icons-item" href="<?php echo esc_url($instagram); ?>" target="_blank" aria-label="Instagram"><i class="fa-brands fa-instagram"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($linkedin)) : ?>
                                <li><a class="styled-icons-item" href="<?php echo esc_url($linkedin); ?>" target="_blank" aria-label="LinkedIn"><i class="fa-brands fa-linkedin"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($youtube)) : ?>
                                <li><a class="styled-icons-item" href="<?php echo esc_url($youtube); ?>" target="_blank" aria-label="YouTube"><i class="fa-brands fa-youtube"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>

        <div class="header-middle ">
            <div class="container">
                <div class="row">
                    <div class="col-xl-auto align-self-center header-mid-left text-center text-xl-left">
                        <?php
                        $options = get_option('lga_settings');
                        $logo_id = isset($options['logo']) ? intval($options['logo']) : 0;
                        $logo_url = $logo_id ? wp_get_attachment_url($logo_id) : '';
                        ?>

                        <a class="menuzord-brand site-brand" href="<?php echo esc_url(home_url('/')); ?>" aria-label="NetraConTech Logo">
                            <?php if ($logo_url): ?>
                                <img src="<?php echo esc_url($logo_url); ?>" alt="NetraConTech Logo" class="logo-img" width="200" height="50">
                            <?php else: ?>
                                <img src="<?php echo esc_url($logo_url); ?>" alt="NetraConTech Logo" class="logo-img" width="200
                                " height="50">
                            <?php endif; ?>
                        </a>


                        <!-- <a class="menuzord-brand site-brand" href="<?php echo esc_url(home_url('/')); ?>">
                            <img src="<?php echo esc_url($logo_url); ?>" alt="NetraConTech Logo" class="logo-img" width="200
                                " height="50">
                        </a> -->
                    </div>
                    <div class="col-xl-auto align-self-center ml-xl-auto header-mid-right text-center text-xl-right">
                        <div class="header-mid-column3-container">
                            <div class="row justify-content-md-center">
                                <?php
                                $settings = get_option('lga_settings');
                                $contact_number = isset($settings['contact_number']) ? $settings['contact_number'] : '+92 347 1234786';
                                $contact_email = isset($settings['contact_email']) ? $settings['contact_email'] : 'ExampleTech@gmail.com';
                                ?>
                                <div class="col-md-auto element text-center text-md-left">
                                    <div class="contact-info big-icon">
                                        <div class="left-thumb">
                                            <a href="tel:<?php echo esc_attr($contact_number); ?>" aria-label="call us at">
                                                <i class="fa-solid fa-phone font-icon sm-display-block"></i>
                                            </a>
                                        </div>
                                        <div class="media-body">
                                            <h5 class="title">Call us at</h5>
                                            <div class="subtitle">
                                                <a href="tel:<?php echo esc_attr($contact_number); ?>" aria-label="call us at"><?php echo esc_html($contact_number); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-auto element text-center text-md-left">
                                    <div class="contact-info big-icon">
                                        <div class="left-thumb">
                                            <a href="mailto:<?php echo esc_attr($contact_email); ?>" aria-label="email us at">
                                                <i class="fa fa-envelope font-icon sm-display-block"></i>
                                            </a>
                                        </div>
                                        <div class="media-body">
                                            <h5 class="title">Email us</h5>
                                            <div class="subtitle">
                                                <a href="mailto:<?php echo esc_attr($contact_email); ?>" aria-label="email us at"><?php echo esc_html($contact_email); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-nav">
            <div class="header-nav-wrapper navbar-scrolltofixed">
                <div class="menuzord-container header-nav-container ">
                    <div class="container position-relative">
                        <div class="header-nav-container-inner">
                            <div class="row">
                                <div class="col">
                                    <div class="row header-nav-col-row">
                                        <div class="col-sm-auto align-self-center menuzord-brand-parent">
                                            <a class="menuzord-brand site-brand" href="<?php echo esc_url(home_url('/')); ?>">
                                                <img src="<?php echo esc_url($logo_url); ?>" alt="NetraConTech Logo" class="logo-img" width="200
                                " height="50">
                                            </a>
                                        </div>
                                        <div class="col-sm-auto align-self-center top-nav-parent">
                                            <nav id="top-primary-nav" class="menuzord blue menuzord-color-blue menuzord-rounded-boxed p-0 menuzord-responsive" data-effect="slide" data-animation="none" data-align="left">
                                                <a href="#" class="showhide" onclick="toggleMenu()" aria-label="Toggle Menu"><em></em><em></em><em></em></a>
                                                <?php
                                                wp_nav_menu(array(
                                                    'theme_location' => 'primary',
                                                    'container'      => false,
                                                    'menu_id'        => 'main-nav',
                                                    'menu_class'     => 'menuzord-menu menuzord-indented scrollable',
                                                    'fallback_cb'    => false,
                                                ));
                                                ?>
                                            </nav>
                                        </div>
                                    </div>
                                    <div id="top-nav-search-form" class="clearfix" style="display: none;">
                                        <form>
                                            <input type="text" name="s" value="" placeholder="Type and Press Enter..." autocomplete="off">
                                        </form>
                                        <a href="#" id="close-search-btn"><i class="fa fa-times"></i></a>
                                    </div>
                                </div>
                                <div class="col-12 d-block d-xl-none">
                                    <nav id="top-primary-nav-clone" class="menuzord d-block d-xl-none blue menuzord-color-blue menuzord-rounded-boxed menuzord-responsive" data-effect="slide" data-animation="none" data-align="right">
                                        <a href="#" class="showhide" onclick="toggleMenu()" aria-label="Toggle Menu"><em></em><em></em><em></em></a>
                                        <?php
                                        wp_nav_menu(array(
                                            'theme_location' => 'primary',
                                            'container'      => false,
                                            'menu_id'        => 'main-nav-clone',
                                            'menu_class'     => 'menuzord-menu menuzord-right menuzord-indented',
                                            'fallback_cb'    => false,
                                        ));
                                        ?>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </header>
    <style>
        #main-nav-clone {
            display: none;
            transition: all 0.3s ease-in-out;
        }
    </style>

    <script>
        function toggleMenu() {
            // alert('Menu toggled');
            let navMenu = document.querySelector('#main-nav-clone');

            if (navMenu) {
                if (navMenu.style.display === 'none' || navMenu.style.display === '') {
                    navMenu.style.display = 'block';
                } else {
                    navMenu.style.display = 'none';
                }
            }
        }
        document.addEventListener("DOMContentLoaded", function() {
            let currentUrl = window.location.href;
            let path = window.location.pathname;

            let menuItems = document.querySelectorAll("#main-nav .menu-item a");

            menuItems.forEach(function(menuItem) {
                let href = menuItem.href;
                let linkPath = new URL(href).pathname;

                // Check if path matches exactly or starts with it (for sub-pages)
                if (path === linkPath || path.startsWith(linkPath + "/")) {
                    menuItem.classList.add("active");
                    menuItem.parentElement.classList.add("active");
                }
            });
        });
    </script>