<?php include "header.php"; ?>


<div class="mainSlider-new">
    <?php
    $home_page_data = get_option('home_page_data');
    $banner_ids = isset($home_page_data['banner']) && is_array($home_page_data['banner']) ? array_filter(array_map('intval', $home_page_data['banner'])) : [];
    $mobile_banner_ids = isset($home_page_data['mobile_banner']) && is_array($home_page_data['mobile_banner']) ? array_filter(array_map('intval', $home_page_data['mobile_banner'])) : [];


    if (!empty($banner_ids)) :
    ?>
        <div class="carousel-new">
            <?php foreach ($banner_ids as $index => $id):
                $image_url = wp_get_attachment_url($id);
                if (!$image_url) continue; // skip if no image
                $mobile_image_url = (!empty($mobile_banner_ids) && isset($mobile_banner_ids[$index]) && $mobile_banner_ids[$index]) ? wp_get_attachment_url($mobile_banner_ids[$index]) : '';
            ?>
                <div class="carousel-item-new">
                    <img decoding="async" loading="lazy" class="desktop-new" src="<?php echo esc_url($image_url); ?>" alt="Slider Image">
                    <?php if (!empty($mobile_image_url)): ?>
                        <img class="mobile-new" src="<?php echo esc_url($mobile_image_url); ?>" alt="Mobile Slide" width="400" height="400">
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <button class="carousel-control-prev-new">&#8249;</button>
        <button class="carousel-control-next-new">&#8250;</button>

        <div class="carousel-indicators-new">
            <?php foreach ($banner_ids as $index => $id): ?>
                <button data-slide-to="<?php echo esc_attr($index); ?>" <?php if ($index === 0) echo ' class="active"'; ?> aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>


</div>

<style>
    .slider-container {
        width: 100%;
        height: 80vh;
        background-color: #2c302e;
        display: flex;
        position: relative
    }

    .left-col {
        width: 100%;
        box-sizing: border-box;
        overflow: hidden
    }

    .left-col {
        background-size: cover;
        background-postion: center top;
        overflow: hidden;
        position: relative
    }

    .left-col .slide {
        position: absolute;
        width: 100%;
        height: 100%;
        background-position: left top !important;
        background-size: cover !important;
        background-repeat: no-repeat;
        opacity: 0;
        transition: 1s cubic-bezier(1, .04, .355, 1) transform, 1s cubic-bezier(.68, -.55, .265, 1.55) clip-path;
        transform: translateY(-100%);
        scale: 1;
        z-index: -1
    }

    .left-col .slide.current {
        opacity: 1;
        transform: translateY(0) scale(1.25);
        z-index: 2;
        clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%)
    }

    .nav-slider {
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 6;
        overflow: hidden
    }

    .nav-slider a {
        color: #fafafa;
        font-size: 3rem;
        text-shadow: 1px 1px 4px rgba(0, 0, 0, .4)
    }

    .mainSlider-new {
        width: 100%;
        /* height:75vh; */
        margin: auto;
        overflow: hidden;
        position: relative
    }

    .carousel-new {
        display: flex;
        transition: transform .5s ease-in-out
    }

    .carousel-item-new {
        min-width: 100%;
        display: flex;
        justify-content: center;
        align-items: center
    }

    .desktop-new {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block
    }

    .mobile-new {
        display: none;
        width: 100%;
        height: 100%;
        object-fit: cover
    }

    .carousel-control-next-new,
    .carousel-control-prev-new {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: var(--site-color);
        opacity: 0.9;
        ;
        color: #fff;
        border: none;
        padding: 10px;
        cursor: pointer;
        font-size: 3rem
    }

    .carousel-control-prev-new {
        left: 0px;
        border-radius: 0px 5px 5px 0px;
    }

    .carousel-control-next-new {
        right: 0px;
        border-radius: 5px 0px 0px 5px;
    }

    .carousel-indicators-new {
        position: absolute;
        bottom: 10px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 5px
    }

    .carousel-indicators-new button {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        border: none;
        background: gray;
        cursor: pointer;
        margin-right: 7px;
    }

    .carousel-indicators-new button.active {
        background: var(--site-color);
        width: 30px;
        border-radius: 10px;
    }

    .carousel-control-prev-new:hover {
        opacity: 1;
    }

    .carousel-control-next-new:hover {
        opacity: 1;
    }

    /* @media (max-width:1024px){
        .desktop-new{display:none}
        .mobile-new{display:block}
    } */

    @media (max-width:768px) {
        .desktop-new {
            display: none
        }

        .mobile-new {
            display: block;
            width: 100%;
            object-fit: fill
        }

        .carousel-indicators-new {
            position: absolute;
            bottom: 20px;
            left: 52%;
            transform: translateX(-50%);
            display: flex;
            gap: 5px
        }
    }

    .win-bike {
        text-align: center;
        position: relative;
        background: #fff;
        padding: 0px 20px;
        border-radius: 10px
    }

    .win-slider-container {
        position: relative;
        overflow: hidden;
        width: 100%;
        height: 400px;
        border-radius: 8px
    }

    .win-slider {
        display: flex;
        flex-direction: column;
        transition: transform .5s ease-in-out
    }

    .win-bike-item {
        width: 100%;
        text-align: center;
        margin-bottom: 10px;
    }

    .win-bike-item img {
        border-radius: 5px;
        aspect-ratio: 3/2;
    }

    .win-slider-buttons {
        position: absolute;
        top: 52.5%;
        right: 0px;
        transform: translateY(-50%);
        display: flex;
        flex-direction: column;
        gap: 10px
    }

    .win-slider-buttons button {
        width: 35px;
        height: 35px;
        background-color: var(--site-color);
        color: #fff;
        border: none;
        cursor: pointer;
        font-size: 18px;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, .2);
        transition: background .3s
    }

    .win-slider-buttons button:hover {
        background-color: var(--winer-carosel-hover)
    }

    @media (max-width:500px) {
        .win-slider-buttons {
            top: 58.5%;
        }
    }

    .desktop-new {
        aspect-ratio: 3/1;
    }
</style>


<script>
    const carousel = document.querySelector(".carousel-new");
    const items = document.querySelectorAll(".carousel-item-new");
    const prevButton = document.querySelector(".carousel-control-prev-new");
    const nextButton = document.querySelector(".carousel-control-next-new");
    const indicators = document.querySelectorAll(".carousel-indicators-new button");

    let index = 1; // Start from 1 because of cloned first item
    let isTransitioning = false;

    // Clone first and last slides for smooth looping
    const firstClone = items[0].cloneNode(true);
    const lastClone = items[items.length - 1].cloneNode(true);

    // Append cloned slides
    carousel.appendChild(firstClone);
    carousel.insertBefore(lastClone, items[0]);

    const allItems = document.querySelectorAll(".carousel-item-new");
    carousel.style.transform = `translateX(-${index * 100}%)`;

    function updateCarousel() {
        if (isTransitioning) return;
        isTransitioning = true;

        carousel.style.transition = "transform 0.5s ease-in-out";
        carousel.style.transform = `translateX(-${index * 100}%)`;

        setTimeout(() => {
            if (index === allItems.length - 1) {
                carousel.style.transition = "none";
                index = 1; // Reset to first real item
                carousel.style.transform = `translateX(-${index * 100}%)`;
            } else if (index === 0) {
                carousel.style.transition = "none";
                index = allItems.length - 2; // Reset to last real item
                carousel.style.transform = `translateX(-${index * 100}%)`;
            }
            isTransitioning = false;
            updateIndicators(); // Sync indicators after transition
        }, 500);
    }

    nextButton.addEventListener("click", () => {
        if (!isTransitioning) {
            index++;
            updateCarousel();
        }
    });

    prevButton.addEventListener("click", () => {
        if (!isTransitioning) {
            index--;
            updateCarousel();
        }
    });

    // ✅ Fix indicator syncing
    indicators.forEach((btn, i) => {
        btn.addEventListener("click", () => {
            index = i + 1; // Adjust for cloned slides
            updateCarousel();
        });
    });

    // ✅ Updates indicators correctly
    function updateIndicators() {
        let realIndex = index - 1; // Adjust for cloned slides
        if (index === allItems.length - 1) realIndex = 0; // Loop to first
        if (index === 0) realIndex = indicators.length - 1; // Loop to last

        indicators.forEach((btn, i) => btn.classList.toggle("active", i === realIndex));
    }

    // ✅ Initial indicator state
    updateIndicators();

    // Hide controls and indicators if only one image exists
    if (items.length === 1) {
        prevButton.style.display = "none";
        nextButton.style.display = "none";
        document.querySelector(".carousel-indicators-new").style.display = "none";
    }
</script>


<div class="main-content">

    <section>
        <div class="container">
            <div class="row tm-blog-sidebar-row">
                <div class="col-lg-12">
                    <div class="main-content-area">
                        <div id="page-19314" class="post-19314 page type-page status-publish hentry">
                            <div class="entry-content">
                                <div class="page-content">
                                    <section class="wpb-content-wrapper">

                                        <div class="vc_row wpb_row vc_row-fluid mt-responsive--200 pt-sm-0 z-index-2 vc_custom_1567605220833 vc-row-tm-section-padding vc-row-tm-parent-section">
                                            <div class="wpb_column vc_column_container vc_col-sm-12">
                                                <div class="vc_column-inner ">
                                                    <div class="wpb_wrapper">
                                                        <div class="vc_row wpb_row vc_inner vc_row-fluid vc_custom_1603550053690 vc_row-has-fill vc_row-o-equal-height vc_row-flex">
                                                            <div class="bg-theme-colored1 wpb_column vc_column_container vc_col-sm-4 vc_col-has-fill section-typo-dark">
                                                                <div class="vc_column-inner vc_custom_1622806789693">
                                                                    <div class="wpb_wrapper">
                                                                        <div class="tm-sc tm-sc-icon-box icon-box icon-left tm-iconbox-icontype-image text-left iconbox-centered-in-responsive iconbox-hover-move-up-animation icon-position-icon-left   vc_custom_1629176730316">
                                                                            <div class="icon-box-wrapper">
                                                                                <a class="icon icon-type-image  icon-default   " target="_self" href="#">
                                                                                    <img decoding="async" src="<?php echo get_template_directory_uri(); ?>/assets/images/transmition-line.webp" width="72" alt="Image">
                                                                                </a>
                                                                                <div class="icon-text">
                                                                                    <h5 class="icon-box-title mt-0 mb-10"><a target="_self" href="#">Transmission Line</a></h5>

                                                                                    <div class="content">
                                                                                        <p>Smecon has constructed more than 2000km long Transmission Lines ranging from 110kV to 500kV in Afghanistan, Pakistan…</p>
                                                                                    </div>
                                                                                    <div class="btn-view-details ">
                                                                                        <a target="_self" href="#" class="btn btn-plain-text-with-arrow text-white btn-sm">Read More</a>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="clearfix"></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="bg-theme-colored2 wpb_column vc_column_container vc_col-sm-4 vc_col-has-fill section-typo-light">
                                                                <div class="vc_column-inner vc_custom_1622811078668">
                                                                    <div class="wpb_wrapper">
                                                                        <div class="tm-sc tm-sc-icon-box icon-box icon-left tm-iconbox-icontype-image text-left iconbox-centered-in-responsive iconbox-hover-move-up-animation icon-position-icon-left   vc_custom_1629176759390">
                                                                            <div class="icon-box-wrapper">
                                                                                <a class="icon icon-type-image  icon-default   text-white" target="_self" href="#">
                                                                                    <img decoding="async" src="<?php echo get_template_directory_uri(); ?>/assets/images/sub-station.webp" width="72" alt="Image"> </a>
                                                                                <div class="icon-text">
                                                                                    <h5 class="icon-box-title mt-0 mb-10">
                                                                                        <a target="_self" href="#">Sub Station</a>
                                                                                    </h5>
                                                                                    <div class="content">
                                                                                        <p>Smecon has constructed more than 35 Sub-Stations in Pakistan, Afghanistan, and Tajikistan among most of them as EPC…</p>
                                                                                    </div>

                                                                                    <div class="btn-view-details ">
                                                                                        <a target="_self" href="#" class="btn btn-plain-text-with-arrow btn-sm text-white">Read More </a>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="clearfix"></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="bg-theme-colored1 wpb_column vc_column_container vc_col-sm-4 vc_col-has-fill section-typo-light">
                                                                <div class="vc_column-inner vc_custom_1603550141074">
                                                                    <div class="wpb_wrapper">
                                                                        <div class="tm-sc tm-sc-icon-box icon-box icon-left tm-iconbox-icontype-image text-left iconbox-centered-in-responsive iconbox-hover-move-up-animation icon-position-icon-left   vc_custom_1629176806005">
                                                                            <div class="icon-box-wrapper">
                                                                                <a class="icon icon-type-image  icon-default   text-white white -text" target="_self" href="#">
                                                                                    <img decoding="async" src="<?php echo get_template_directory_uri(); ?>/assets/images/telecom.webp" width="65" alt="Image"> </a>
                                                                                <div class="icon-text">
                                                                                    <h5 class="icon-box-title mt-0 mb-10">
                                                                                        <a target="_self" href="#"> Telecom</a>
                                                                                    </h5>
                                                                                    <div class="content">
                                                                                        <p>Smecon has completed more than 500 Telenor Sites on behalf of Nokia-Siemens Networks (NSN) in the areas of AJK, Gilgit, KKH…</p>
                                                                                    </div>

                                                                                    <div class="btn-view-details ">
                                                                                        <a target="_self" href="#" class="btn btn-plain-text-with-arrow btn-sm text-white">Read More </a>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="clearfix"></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="vc_row wpb_row vc_row-fluid vc-row-tm-section-padding vc-row-tm-parent-section my-4">
                <div class="wpb_column vc_column_container vc_col-sm-7">
                    <div class="tm-element-holder mb-lg-30 vc_custom_1566486869403">
                        <div class="tm-element-holder-content">
                            <h5 class="tm-sc tm-sc-line-with-text text-gray line-after-title">
                                <span class="horizontal-text">Who We Are</span>
                                <span class="horizontal-line bg-theme-colored1"></span>
                            </h5>
                            <h2>Welcome to <span class="text-theme-colored1">Smecon Private Limited</span></h2>
                            <p>SMECON PVT LTD is proud to have the state-of-the-art machinery and equipment for EPC Grid and power Transmission line projects. Testing equipment from renowned manufacturers like, OMICRON, Programma, Magar, Doble, Fluke etc. We also offer design build general contracting, pre- construction planning and comprehensive project managemnet services and self- performed construction services including survey, civil & structural design, excavation and concreting.</p>
                            <a href="#" target="_self" class="btn btn-theme-colored1 btn-round mt-3">Read More</a>
                        </div>
                    </div>
                </div>
                <div class="wpb_column vc_column_container vc_col-sm-5">
                    <div class="tm-element-holder vc_custom_1566456590545" style="border: 8px solid #fff;">
                        <div class="tm-element-holder-content">
                            <div class="wpb_single_image wpb_content_element vc_align_center">
                                <div id="about-video-loader" style="">
                                    <div style="text-align:center;">
                                        <div class="loader-spinner" style="margin-bottom:16px;">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="sr-only">Loading...</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="about-video-wrapper" style="display:none;">
                                    <video 
                                        id="about-video"
                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/about-vid2.mp4" 
                                        loop muted autoplay playsinline
                                        style="width: 100%; height: auto; max-width: 100%; border-radius: 10px;"
                                    ></video>
                                </div>
                                <script>
                                    window.addEventListener('load', function() {
                                        var loader = document.getElementById('about-video-loader');
                                        var wrapper = document.getElementById('about-video-wrapper');
                                        loader.style.display = 'none';
                                        wrapper.style.display = 'block';
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>


    <!-- ==================================================================================	 -->
    <style>
        .bg-gray {
            background-color: #f9f9f9;
        }

        .site-heading h2 {
            display: block;
            font-weight: 700;
            margin-bottom: 10px;
            text-transform: uppercase;
        }

        .site-heading h2 span {
            color: var(--site-color);
        }

        .site-heading h4 {
            display: inline-block;
            padding-bottom: 20px;
            margin: 0;
            position: relative;
            text-transform: capitalize;
            z-index: 1;
        }

        .site-heading h4::before {
            background: var(--site-color) none repeat scroll 0 0;
            bottom: 0;
            content: "";
            height: 2px;
            left: 50%;
            margin-left: -25px;
            position: absolute;
            width: 50px;
        }

        .site-heading {
            margin-bottom: 60px;
            overflow: hidden;
        }

        .carousel-shadow .owl-stage-outer {
            margin: -15px -15px 0;
            padding: 15px;
        }

        .we-offer-area .our-offer-carousel .owl-dots .owl-dot span {
            background: #ffffff none repeat scroll 0 0;
            border: 2px solid;
            height: 15px;
            margin: 0 5px;
            width: 15px;
        }

        .we-offer-area .our-offer-carousel .owl-dots .owl-dot.active span {
            background: var(--site-color) none repeat scroll 0 0;
            border-color: var(--site-color);
        }

        .we-offer-area .item {
            background: #ffffff none repeat scroll 0 0;
            border-left: 2px solid var(--site-color);
            -moz-box-shadow: 0 0 10px #cccccc;
            -webkit-box-shadow: 0 0 10px #cccccc;
            -o-box-shadow: 0 0 10px #cccccc;
            box-shadow: 0 0 10px #cccccc;
            overflow: hidden;
            padding: 30px;
            position: relative;
            z-index: 1;
        }

        .we-offer-area.text-center .item {
            background: #ffffff none repeat scroll 0 0;
            border: medium none;
            padding: 35px;
            border-radius: 10px;
            cursor: pointer;
            height: 100%;
        }

        .we-offer-area.text-center .item i {
            background: var(--site-color) none repeat scroll 0 0;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            color: #ffffff;
            font-size: 40px;
            height: 80px;
            line-height: 80px;
            position: relative;
            text-align: center;
            width: 80px;
            z-index: 1;
            transition: all 0.35s ease-in-out;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
            margin-bottom: 25px;
        }

        .we-offer-area.text-center .item i::after {
            border: 2px solid var(--site-color);
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            content: "";
            height: 90px;
            left: -5px;
            position: absolute;
            top: -5px;
            width: 90px;
            z-index: -1;
            transition: all 0.35s ease-in-out;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
        }

        .we-offer-area.item-border-less .item {
            border: medium none;
        }

        .we-offer-area .our-offer-items.less-carousel .equal-height {
            margin-bottom: 30px;
        }

        .we-offer-area.item-border-less .item .number {
            font-family: "Poppins", sans-serif;
            font-size: 50px;
            font-weight: 900;
            opacity: 0.1;
            position: absolute;
            right: 30px;
            top: 30px;
        }

        .our-offer-carousel.center-active .owl-item:nth-child(2n) .item,
        .we-offer-area.center-active .single-item:nth-child(2n) .item {
            background: var(--site-color) none repeat scroll 0 0;
        }

        .our-offer-carousel.center-active .owl-item:nth-child(2n) .item i,
        .our-offer-carousel.center-active .owl-item:nth-child(2n) .item h4,
        .our-offer-carousel.center-active .owl-item:nth-child(2n) .item p,
        .we-offer-area.center-active .single-item:nth-child(2n) .item i,
        .we-offer-area.center-active .single-item:nth-child(2n) .item h4,
        .we-offer-area.center-active .single-item:nth-child(2n) .item p {
            color: #ffffff;
        }

        .we-offer-area .item i {
            color: var(--site-color);
            display: inline-block;
            font-size: 60px;
            margin-bottom: 20px;
        }

        .we-offer-area .item h4 {
            font-weight: 600;
            text-transform: capitalize;
        }

        .we-offer-area .item p {
            margin: 0;
        }

        .we-offer-area .item i,
        .we-offer-area .item h4,
        .we-offer-area .item p {
            transition: all 0.35s ease-in-out;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
        }

        .we-offer-area .item::after {
            background: var(--site-color) none repeat scroll 0 0;
            content: "";
            height: 100%;
            left: -100%;
            position: absolute;
            top: 0;
            transition: all 0.35s ease-in-out;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
            width: 100%;
            z-index: -1;
        }

        .we-offer-area .item:hover::after {
            left: 0;
        }

        .we-offer-area .item:hover i,
        .we-offer-area .item:hover h4,
        .we-offer-area .item:hover p {
            color: #ffffff !important;
        }

        .we-offer-area.text-center .item:hover i::after {
            border-color: #ffffff !important;
        }

        .we-offer-area.text-center .item:hover i {
            background-color: #ffffff !important;
            color: var(--site-color) !important;
        }

        .we-offer-area.text-left .item i {
            background: var(--site-color) none repeat scroll 0 0;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            color: #ffffff;
            display: inline-block;
            font-size: 60px;
            height: 100px;
            line-height: 100px;
            margin-bottom: 30px;
            position: relative;
            width: 100px;
            z-index: 1;
            text-align: center;
        }

        .we-offer-area.text-left .item i::after {
            border: 2px solid var(--site-color);
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            content: "";
            height: 120px;
            left: -10px;
            position: absolute;
            top: -10px;
            width: 120px;
        }

        .ab-img img {
            filter: drop-shadow(2px 4px 6px var(--site-color));
            border-radius: 10px;
        }
    </style>
    <section class="we-offer-area text-center bg-gray py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="site-heading text-center">
                        <h2>What we <span>Offer</span></h2>
                        <p>Our services are designed to meet the needs of our clients and help them achieve their goals.</p>
                    </div>
                </div>
            </div>
            <div class="row our-offer-items less-carousel" style="justify-content: center;">
                <!-- Single Item -->
                <?php
                $home_page_data = get_option('home_page_data');
                $offers = isset($home_page_data['offers']) && is_array($home_page_data['offers']) ? $home_page_data['offers'] : [];

                foreach ($offers as $offer) :
                    $icon_id = isset($offer['iconimage']) ? intval($offer['iconimage']) : 0;
                    $icon_url = $icon_id ? wp_get_attachment_url($icon_id) : get_template_directory_uri() . '/assets/images/com.jpg';
                    $title = isset($offer['offer_title']) ? esc_html($offer['offer_title']) : '';
                    $desc = isset($offer['offer_description']) ? esc_html($offer['offer_description']) : '';
                ?>
                    <!-- Single Item -->
                    <div class="col-lg-4 col-md-6 col-sm-12 equal-height">
                        <div class="item offer-card">
                            <div class="i">
                                <img src="<?php echo esc_url($icon_url); ?>" alt="<?php echo esc_attr($title); ?>">
                            </div>
                            <h4><?php echo $title; ?></h4>
                            <p class="decp"><?php echo $desc; ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <style>
        .offer-card .i img {
            width: 50px;
            height: 50px;
        }

        /* .i{
            border: 2px solid var(--site-color);
            padding: 5px;
            border-radius: 50px;
        } */

        .decp {
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>

    <!-- ===============================  Success Stories  ======================================= -->


    <div class="success-stories-section mt-5" style="position: relative; box-sizing: border-box;">
        <div class="success-stories-row">
            <div class="success-stories-col">
                <div class="success-stories-title">
                    <div class="success-stories-title-wrapper">
                        <h2 class="success-stories-heading">
                            <span>Success Stories</span>
                        </h2>
                        <div class="success-stories-separator"></div>
                    </div>
                </div>
            <?php
            $options = get_option("lga_settings");
            $video_url = isset($options['Video_link']) ? $options['Video_link'] : '';
            $video_id = extract_youtube_id($video_url);
            ?>

            <div id="success-stories-video-loader" style="text-align:center;">
                <div class="loader-spinner" style="margin-bottom:16px;">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>
            </div>
            <div id="success-stories-video-wrapper" style="display:none;">
                <?php if ($video_id): ?>
                    <div class="success-stories-video-wrapper">
                        <iframe
                            id="success-stories-video-iframe"
                            src=""
                            title="YouTube video player"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            referrerpolicy="strict-origin-when-cross-origin"
                            allowfullscreen>
                        </iframe>
                    </div>
                <?php endif; ?>
            </div>
            <script>
            document.addEventListener("DOMContentLoaded", function() {
                var loaded = false;
                var section = document.querySelector(".success-stories-section");
                var loader = document.getElementById("success-stories-video-loader");
                var wrapper = document.getElementById("success-stories-video-wrapper");
                var iframe = document.getElementById("success-stories-video-iframe");
                var videoId = "<?php echo esc_js($video_id); ?>";
                function loadVideo() {
                    if (loaded || !videoId) return;
                    loaded = true;
                    loader.style.display = "none";
                    wrapper.style.display = "block";
                    iframe.src = "https://www.youtube.com/embed/" + videoId;
                }
                if ("IntersectionObserver" in window) {
                    var observer = new IntersectionObserver(function(entries) {
                        if (entries[0].isIntersecting) {
                            loadVideo();
                            observer.disconnect();
                        }
                    }, { threshold: 0.2 });
                    observer.observe(section);
                } else {
                    // fallback: load after scroll
                    window.addEventListener("scroll", function() {
                        var rect = section.getBoundingClientRect();
                        if (rect.top < window.innerHeight && rect.bottom > 0) {
                            loadVideo();
                        }
                    });
                }
            });
            </script>



            </div>
        </div>
        <style>
            .success-stories-section {
                width: 100%;
                padding: 60px 0;
                background-color: #04003b;
                background-image: url("https://www.transparenttextures.com/patterns/asfalt-dark.png");
            }

            .success-stories-row {
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
            }

            .success-stories-col {
                width: 100%;
                max-width: 900px;
                margin: 0 auto;
                padding: 0 16px;
            }

            .success-stories-title {
                text-align: center;
                margin-bottom: 32px;
            }

            .success-stories-title-wrapper {
                display: inline-block;
            }

            .success-stories-heading {
                color: #fff;
                font-size: 2.5rem;
                margin: 0;
                font-weight: 700;
                letter-spacing: 1px;
            }

            .success-stories-separator {
                width: 60px;
                height: 4px;
                background: var(--site-color, #f9b233);
                margin: 16px auto 0 auto;
                border-radius: 2px;
            }

            .success-stories-video-wrapper {
                max-width: 700px;
                margin: 0 auto;
                border-radius: 12px;
                overflow: hidden;
                box-shadow: 0 4px 24px rgba(0, 0, 0, 0.18);
                background: #000;
            }

            .success-stories-video-wrapper iframe {
                width: 100%;
                aspect-ratio: 16/9;
                min-height: 300px;
                border: none;
                display: block;
            }

            @media (max-width: 900px) {
                .success-stories-col {
                    max-width: 100%;
                }

                .success-stories-video-wrapper {
                    max-width: 100%;
                }
            }

            @media (max-width: 600px) {
                .success-stories-heading {
                    font-size: 1.5rem;
                }

                .success-stories-video-wrapper iframe {
                    min-height: 180px;
                }
            }
        </style>
    </div>



    <!-- ===========================  Customers Company Slider  ============================ -->

    <div class="container my-5">
        <div class="col-lg-12">
            <div class="vc_column-inner">
                <div class="wpb_wrapper">
                    <div class="text-center">
                        <div class="title-wrapper">
                            <h2 class="title" style="line-height: 1.1">
                                <span class="">Valuable</span>
                                <span class="text-theme-colored1">Customers</span>
                                <span class="">&amp; Partners</span>
                            </h2>
                            <div class="title-seperator-line"></div>
                        </div>
                    </div>

                    <div class="wpb_images_carousel">
                        <style>
                            .vc_carousel-slideline {
                                position: relative;
                                width: 100%;
                                overflow: hidden;
                                margin: 3rem auto;
                            }

                            .vc_carousel-slideline-inner {
                                display: flex;
                                transition: transform 0.5s ease-in-out;
                                will-change: transform;
                            }

                            .vc_item {
                                min-width: 200px;
                                margin: 0 5px;
                            }

                            .vc_item img {
                                width: 100%;
                                height: auto;
                                display: block;
                                border-radius: 10px;
                            }

                            .vc_left,
                            .vc_right {
                                position: absolute;
                                top: 50%;
                                transform: translateY(-50%);
                                background: var(--site-color);
                                color: white;
                                padding: 10px;
                                cursor: pointer;
                                border: none;
                                font-size: 18px;
                                z-index: 99;
                            }

                            .vc_left {
                                left: 0px;
                                border-radius: 0px 5px 5px 0px;
                            }

                            .vc_right {
                                right: 0px;
                                border-radius: 5px 0px 0px 5px;
                            }

                            .vc_dots {
                                text-align: center;
                                margin-top: 2rem;
                            }

                            .vc_dots span {
                                height: 10px;
                                width: 10px;
                                margin: 0 5px;
                                background-color: #bbb;
                                border-radius: 50%;
                                display: inline-block;
                                transition: background-color 0.3s ease;
                                cursor: pointer;
                            }

                            .vc_dots .active {
                                background-color: var(--site-color);
                                width: 20px;
                                border-radius: 5px;
                            }

                            @media (max-width: 768px) {
                                .vc_carousel-slideline-inner {
                                    flex-wrap: nowrap;
                                }

                                .vc_item {
                                    min-width: 150px;
                                }

                                .vc_left,
                                .vc_right {
                                    font-size: 14px;
                                    padding: 5px;
                                }

                                .vc_dots span {
                                    height: 8px;
                                    width: 8px;
                                }

                                .vc_dots .active {
                                    width: 16px;
                                }
                            }
                        </style>

                        <div class="vc_carousel-slideline">
                            <div class="vc_carousel-slideline-inner">
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/1.webp" alt="Image 1"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/2.webp" alt="Image 2"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/3.webp" alt="Image 3"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/4.webp" alt="Image 4"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/5.webp" alt="Image 5"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/6.webp" alt="Image 6"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/7.webp" alt="Image 7"></div>
                                <div class="vc_item"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/8.webp" alt="Image 8"></div>
                            </div>
                        </div>
                        <div class="vc_dots row"></div>


                        <script>
                            document.addEventListener("DOMContentLoaded", function() {
                                const sliderInner = document.querySelector(".vc_carousel-slideline-inner");
                                const sliderItems = document.querySelectorAll(".vc_item");
                                const prevButton = document.querySelector(".vc_left");
                                const nextButton = document.querySelector(".vc_right");
                                const sliderContainer = document.querySelector(".vc_carousel-slideline");
                                const dotsContainer = document.createElement("div");
                                dotsContainer.classList.add("vc_dots");
                                sliderContainer.appendChild(dotsContainer);

                                let index = 0;
                                const itemWidth = sliderItems[0].offsetWidth + 10;
                                const totalItems = sliderItems.length;

                                // Create dots
                                for (let i = 0; i < totalItems; i++) {
                                    const dot = document.createElement("span");
                                    dot.classList.add("vc_dot");
                                    if (i === 0) dot.classList.add("active");
                                    dot.dataset.index = i;
                                    dotsContainer.appendChild(dot);
                                }
                                const dots = document.querySelectorAll(".vc_dot");

                                sliderInner.innerHTML += sliderInner.innerHTML;
                                let totalSlides = totalItems * 2;

                                let autoSlide = setInterval(() => moveSlide("next"), 3000);

                                function moveSlide(direction) {
                                    if (direction === "next") {
                                        index++;
                                    } else {
                                        index--;
                                    }

                                    sliderInner.style.transition = "transform 0.5s ease-in-out";
                                    sliderInner.style.transform = `translateX(-${index * itemWidth}px)`;

                                    setTimeout(() => {
                                        if (index >= totalItems) {
                                            index = 0;
                                            sliderInner.style.transition = "none";
                                            sliderInner.style.transform = `translateX(-${index * itemWidth}px)`;
                                            updateDots();
                                        } else if (index < 0) {
                                            index = totalItems - 1;
                                            sliderInner.style.transition = "none";
                                            sliderInner.style.transform = `translateX(-${index * itemWidth}px)`;
                                            updateDots();
                                        }
                                        updateDots();
                                    }, 500);
                                }

                                function updateDots() {
                                    dots.forEach(dot => dot.classList.remove("active"));
                                    dots[index % totalItems].classList.add("active");
                                }

                                dots.forEach(dot => {
                                    dot.addEventListener("click", function() {
                                        index = parseInt(this.dataset.index);
                                        sliderInner.style.transition = "transform 0.5s ease-in-out";
                                        sliderInner.style.transform = `translateX(-${index * itemWidth}px)`;
                                        updateDots();
                                    });
                                });

                                nextButton.addEventListener("click", () => moveSlide("next"));
                                prevButton.addEventListener("click", () => moveSlide("prev"));

                                // Hover event to stop/start auto-slide
                                sliderContainer.addEventListener("mouseenter", () => clearInterval(autoSlide));
                                sliderContainer.addEventListener("mouseleave", () => {
                                    autoSlide = setInterval(() => moveSlide("next"), 3000);
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- ======================== Happy client and verifed by Companies ==================== -->


    <div class="vc_row" style="position: relative; width: 100%; min-height: 50vh; display: flex; flex-direction: column; align-items: center; justify-content: center; background: url('<?php echo get_template_directory_uri(); ?>/assets/images/page-piling.webp') no-repeat center/cover; margin:0; padding: 50px 20px;">

        <!-- Fun Facts Section -->
        <div class="wpb_column vc_column_container" style="display: flex; justify-content: space-evenly; gap: 40px; flex-wrap: wrap; text-align: center;">

            <div class="funfact">
                <h2 class="counter" style="color: #e9e9e9; font-size: 74px; line-height: 1;">
                    <span class="animate-number" data-value="20" data-animation-duration="1500">20</span>+
                </h2>
                <h3 style="color: #ffffff; font-size: 16px;">Years Of Excellence</h3>
            </div>

            <div class="funfact">
                <h2 class="counter" style="color: #e9e9e9; font-size: 74px; line-height: 1;">
                    <span class="animate-number" data-value="42" data-animation-duration="1500">42</span>
                </h2>
                <h3 style="color: #ffffff; font-size: 16px;">Happy Clients</h3>
            </div>

            <div class="funfact">
                <h2 class="counter" style="color: #e9e9e9; font-size: 74px; line-height: 1;">
                    <span class="animate-number" data-value="496" data-animation-duration="1500">496</span>
                </h2>
                <h3 style="color: #ffffff; font-size: 16px;">Expert Workers</h3>
            </div>

            <div class="funfact">
                <h2 class="counter" style="color: #e9e9e9; font-size: 74px; line-height: 1;">
                    <span class="animate-number" data-value="154" data-animation-duration="1500">154</span>
                </h2>
                <h3 style="color: #ffffff; font-size: 16px;">Projects Done</h3>
            </div>
        </div>

        <!-- Companies Section -->
        <!-- <div class="companies" style="display: flex; justify-content: center; gap: 30px; flex-wrap: wrap;">
            <div class="cm">
                <a href="#">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/com.jpg" alt="Company Logo" style="width: 100%; border-radius: 50px;">
                </a>
            </div>
            <div class="cm">
                <a href="#">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/com.jpg" alt="Company Logo" style="width: 100%; border-radius: 50px;">
                </a>
            </div>
            <div class="cm">
                <a href="#">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/com.jpg" alt="Company Logo" style="width: 100%; border-radius: 50px;">
                </a>
            </div>
        </div> -->
    </div>




    <?php include "footer.php"; ?>