<?php include "header.php"; ?>

<style>
    body {
        font-family: Arial, sans-serif;
    }

    .main-content {
        margin: 20px 0;
    }

    .project-detail {
        padding: 50px 0;
    }

    .project-detail h2,
    .project-detail h3 {
        font-weight: 700;
    }

    .project-detail h2 {
        font-size: 1.6rem;
        margin-bottom: 20px;
    }

    .project-detail h3 {
        font-size: 1.5rem;
        margin-bottom: 15px;
        margin-top: 0;
    }

    .project-detail p,
    .project-detail ul li,
    .project-detail ol li {
        font-size: 16px;
        line-height: 1.7;
    }

    .project-detail ul {
        padding-left: 0;
    }

    .project-detail ul li {
        margin-bottom: 10px;
        list-style-type: none;
    }

    .left-side {
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .right-side {
        padding: 0;
        border-radius: 10px;
        /* box-shadow: 0 0 15px rgba(0, 0, 0, 0.1); */
        height: fit-content;
    }

    .progress {
        height: 2rem;
        border-radius: 5px !important;
    }

    .progress-bar {
        font-size: 16px;
        font-weight: 700;
        border-radius: 5px;
        /* padding: 10px; */
        background-color: var(--site-color);
    }

    .progress-bar {
        color: #fff;
        text-align: center;
        white-space: nowrap;
        transition: width .6s ease;
    }

    .carousel-item img {
        width: 100%;
        height: 400px;
        object-fit: cover;
        border-radius: 5px;
    }

    .carousel-control-prev,
    i.fa-chevron-left,
    .carousel-control-next,
    i.fa-chevron-right {
        font-size: 24px;
        background: var(--site-color);
        padding: 10px;
        width: 34px;

    }

    .carousel-control-prev-icon .fa-chevron-left {
        font-size: 24px;
        width: 5%;
        border-radius: 5px;
        color: var(--site-color);
        padding: 5px 10px;
    }

    .col-md-9 {
        flex: 0 0 73% !important;
        max-width: 73% !important;
    }

    #project-slider {
        margin: 20px auto;
    }


    .srch-btn {
        background-color: var(--site-color);
        color: #fff;
        border: none;
        padding: 7px 15px;
        border-radius: 0px 5px 5px 0px;
        cursor: pointer;
    }

    .srch {
        margin-bottom: 20px;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .more-project {
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        /* border-top: 3px solid var(--site-color); */
    }

    .stroke-shape {
        position: relative;
        width: 100px;
        height: 4px;
        border-radius: 30px;
        background: linear-gradient(270deg, black 0, var(--site-color) 100%);
        margin: 0px 0px 20px 0px;
    }

    .card-text ul {
        list-style: none;
        padding: 0;
        margin-bottom: 10px;
    }

    .card-text ul li {
        line-height: 30px;
        font-size: 1rem;
        list-style-type: none
    }

    .card-text ul li span {
        font-weight: bold;
        color: var(--site-color);
        font-family: monospace;
    }

    .card-text ul li span i {
        margin-right: 5px;
        color: #002c42;
    }

    .more-project ul li .com {
        float: right;
        color: #fff;
        padding: 5px;
        font-weight: bold;
        border-radius: 2px;
        background-color: var(--site-color);
        font-size: 10px;
    }

    .more-project ul li .pen {
        float: right;
        color: #fff;
        padding: 5px;
        font-weight: bold;
        border-radius: 2px;
        background-color: #ff0000;
        font-size: 10px;
    }

    .carousel-indicators li {
        background-color: #000;
        border: 1px solid #fff;
        width: 12px;
        height: 12px;
        border-radius: 50%;
    }

    /* #project-slider ol {
    margin-left: 0 !important;
} */

    .project-detail ul li::before {
        content: "\2713";
        /* Unicode for check mark */
        color: var(--site-color);
        font-weight: bold;
        display: inline-block;
        width: 1em;
        margin-right: 0.5em;
    }

    .project-detail ol {
        counter-reset: item;
        padding-left: 20px;
        margin-left: 15px;
        /* margin-bottom: 10px; */
    }

    .project-detail ul {
        margin-left: 15px;
        margin-bottom: 10px;
    }

    .project-detail ol li {
        counter-increment: item;
        margin-bottom: 10px;
        position: relative;
        list-style-type: none;
    }

    .project-detail ol li::before {
        content: counter(item) ". ";
        font-weight: bold;
        color: var(--site-color);
        position: absolute;
        left: -21px;
        /* Adjust as needed */
    }

    .project-detail ul li:hover,
    .project-detail ol li:hover {
        /* background-color: rgba(0, 0, 0, 0.05); */
        cursor: pointer;
    }

    .project-detail ul li:hover::before,
    .project-detail ol li:hover::before {
        color: #333;
        /* Change the color on hover */
    }

    /* aside ol li::before,
.tb-content ol li::before {
    content: none;
} */
    .more-project ul li::before {
        content: none;
    }

    .left-side h1 {
        font-size: 1.6rem;
    }

    .carousel-indicators .active {
        width: 25px;
        border-radius: 10px;
        background-color: var(--site-color);
    }

    .serr ul {
        margin-left: 0;
    }

    .serr ul li {
        margin-bottom: 0px;
        list-style-type: none;
        border-bottom: 1px solid #e9e9e9;
        padding: 5px;
        transition: all 0.45s cubic-bezier(.65, 0, .076, 1);
    }

    .serr ul li:hover {
        background-color: wheat;
    }

    .related-blogs ul {
        padding: 0;
    }

    .related-blogs ul li {
        list-style-type: none;
        margin-bottom: 10px;
        display: flex;
        align-items: center;
        justify-content: flex-start;
    }

    .related-blogs ul li img {
        width: 50px;
        height: 50px;
        border-radius: 5px;
        margin-right: 10px;
    }

    .related-blogs ul li a {
        font-size: .8rem;
        color: var(--site-color);
        text-decoration: none;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;

    }

    .related-blogs ul li a:hover {
        text-decoration: underline;
    }

    .related-blogs h3 {
        font-size: 24px;
        margin-bottom: 20px;
    }

    .related-blogs ul {
        margin-left: 0;
    }

    /* @media (max-width: 991px) {
        .right-side {
            display: none;
        }
    } */

    .card-text ul li {
        transition: transform 0.3s ease;
        /* width: max-content; */
    }

    .card-text ul li::before {
        content: none;
    }

    .card-text ul li:hover i {
        color: var(--site-color);
        transition: transform 0.3s ease;
    }

    .card-text ul li:hover i {
        transform: scale(0.8);
        transition: transform 0.3s ease;
    }

    .rows {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .left-side {
        flex: 0 0 74%;
    }

    .bc {
        position: relative;
    }

    .right-side {
        flex: 0 0 24%;
    }
.carousel-control-next, .carousel-control-prev {
    position: absolute;
    top: 50%;
    transform: translateY(-90%);
    bottom: 0;
   
}
.carousel-indicators {
    position: absolute;
    right: 0;
    bottom: 64px;
    left: 0;
    z-index: 15;
    display: flex
;
    justify-content: center;
    padding-left: 0;
    margin-right: 15%;
    margin-left: 15% !important;
    list-style: none;
}
    @media (max-width: 992px) {

        .left-side,
        .right-side {
            flex: 0 0 100% !important;
            max-width: 100%;
        }

        .right-side {
            display: 0 0 100% !important;
            margin-top: 30px;
        }
        #project-slider .carousel-item img{
            max-width: 100%;
            height: auto;
        }
    }
    @media (max-width: 768px){
        #project-slider .carousel-item img{
            width: 100%;
            height: 250px;
            object-fit: cover;
        }
        .left-side{
            padding: 15px;
        }
    }

    .project-design-files .button {
        background-color: #0073aa;
        color: white;
        padding: 6px 12px;
        text-decoration: none;
        border: none;
        border-radius: 3px;
    }

    .project-design-files .button:hover {
        background-color: #005177;
    }
</style>

<?php
/**
 * Template Name: Project Detail
 */
get_header();
$slug = get_query_var("");
$uri = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$segments = explode('/', $uri);
$slug = isset($segments[1]) ? $segments[1] : null;

// Fetch project post by slug
//$project = get_page_by_path($slug, OBJECT, 'project');

global $wpdb;
$project = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT * FROM {$wpdb->posts} WHERE post_type = %s AND post_name = %s AND post_status = 'publish' order by ID desc",
        'project',
        $slug
    )
);

if (!$project) {
    echo '<div class="container"><h2>Project not sdfasdfasdfasdfasf.</h2></div>';
    get_footer();
    exit;
}

$post_id = $project->ID;

// Fetch all meta
$location = get_post_meta($post_id, 'project_location', true);
$employer = get_post_meta($post_id, 'project_employer', true);
$engineer = get_post_meta($post_id, 'project_engineer', true);
$completion_date = get_post_meta($post_id, 'project_completion_date', true);
$funding = get_post_meta($post_id, 'project_funding', true);
$banner_id = get_post_meta($post_id, 'project_banner', true);
$banner = $banner_id ? wp_get_attachment_url($banner_id) : '';
$status = get_post_meta($post_id, 'project_status', true);
$featured_image = get_the_post_thumbnail_url($post_id, 'large');
?>

<div class="main-content">
    <section class="page-title tm-page-title text-left flip text-default page-title-split" style="background-image: url(<?php echo esc_url($banner); ?>);">
        <div class="container padding-extra-large">
            <div class="row"></div>
        </div>
    </section>

    <section class="project-detail">
        <div class="container">
            <div class="rows" style="justify-content: space-between;">
                <div class="left-side">
                    <h1><?php echo esc_html(get_the_title($post_id)); ?></h1>
                    <hr>

                    <!-- Progress bar -->
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: 100%;">
                            <?php echo ucfirst($status); ?>
                        </div>
                    </div>

                    <hr>


                    <h2>Project Details</h2>

                    <div class="card-text">
                        <ul>
                            <li><span><i class="fas fa-map-marker-alt"></i> Location:</span> <?php echo esc_html($location); ?></li>
                            <li><span><i class="fas fa-building"></i> Employer:</span> <?php echo esc_html($employer); ?></li>
                            <li><span><i class="fas fa-user-tie"></i> Engineer:</span> <?php echo esc_html($engineer); ?></li>
                            <li><span><i class="fas fa-calendar-alt"></i> Date of Completion:</span> <?php echo esc_html($completion_date); ?></li>
                            <li><span><i class="fas fa-dollar-sign"></i> Funding:</span> <?php echo esc_html($funding); ?></li>
                        </ul>
                    </div>

                    <div><?php echo wpautop(do_shortcode($project->post_content)); ?></div>
                   

                    <div class="project-design-files">
                        <!-- <label><strong>Design Files:</strong></label>
                        <table style="width:100%;border-collapse:collapse;border:1px solid #ddd;" class="table-responsiv">
                            <thead>
                                <tr style="background:#f7f7f7;">
                                    <th style="border:1px solid #ddd;padding:10px;text-align:center;width:50px">Sr</th>
                                    <th style="border:1px solid #ddd;padding:10px;text-align:left;">File Name</th>
                                    <th style="border:1px solid #ddd;padding:10px;text-align:center;width:250px">Download</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                               
                                $design_files = get_post_meta($post_id, 'project_design_files', true);

                               


                                if (!empty($design_files) && is_array($design_files)) {
                                    $i = 1;
                                    foreach ($design_files as $file) {
                                        $name = isset($file['name']) ? esc_html($file['name']) : '';
                                        $url  = isset($file['url']) ? esc_url($file['url']) : '';

                                        echo '<tr>';
                                        echo '<td style="border:1px solid #ddd;padding:10px;text-align:center;">' . $i . '</td>';
                                        echo '<td style="border:1px solid #ddd;padding:10px;">' . $name . '</td>';
                                        echo '<td style="text-align: center;">';
                                        if (!empty($url)) {
                                            echo '<a href="' . $url . '" class="download-btn" download target="_blank">Download</a>';
                                        } else {
                                            echo '<span class="text-danger">No file</span>';
                                        }
                                        echo '</td>';
                                        echo '</tr>';
                                        $i++;
                                    }
                                } else {
                                    echo '<tr><td colspan="3" style="border:1px solid #ddd;padding:10px;color:#d9534f;text-align:center;">No design files available.</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table> -->

                        <style>
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            .table-responsiv {
                                overflow-x: auto;
                            }
                            

                            th,
                            td {
                                border: 1px solid #ddd;
                                padding: 10px;
                                text-align: left;
                            }

                            .download-btn {
                                background-color: #0073aa;
                                color: white;
                                padding: 8px 53px;
                                width: 100%;
                                text-decoration: none;
                                border: none;
                                border-radius: 3px;
                            }

                            .download-btn:hover {
                                background-color: #005177;
                                color: #fff;
                            }
                        </style>
                    </div>
                </div>

                <aside class="right-side">
                    <div class="more-project mb-4">
                        <h3>Featured Image</h3>
                        <img src="<?php echo esc_url($featured_image ?: $banner); ?>" alt="Featured" style="width: 100%; height: auto; border-radius: 5px;">
                    </div>

                    <div class="more-project mb-4">
                        <h3>Project Completion <span style="color:var(--site-color);">Certificate</span></h3>
                        <div class="stroke-shape"></div>
                        <div class="design-files">
                            <?php
                            $design_files = get_post_meta($post_id, 'project_design_files', true);
                            if (!empty($design_files) && is_array($design_files)) :
                                foreach ($design_files as $file) :
                                    $file_name = !empty($file['name']) ? esc_html($file['name']) : 'Unknown';
                                    $file_url = !empty($file['url']) ? esc_url($file['url']) : '#';
                                    ?>
                                    <div class="design-file" style="margin-bottom: 10px; width: 100%;">
                                        <a href="<?php echo $file_url; ?>" class="download-btn" style="width: 100%;" target="_blank">Download Now</a>
                                    </div>
                                <?php endforeach;
                            else :
                                echo '<p>No design files available.</p>';
                            endif;
                            ?>
                        </div>
                    </div>

                    <!-- Related Posts -->
                    <div class="related-blogs more-project mb-4 bc">
                        <h3>Related Blogs</h3>
                        <div class="stroke-shape"></div>
                        <ul>
                            <?php
                            $related_args = array(
                                'post_type'      => 'post',
                                'posts_per_page' => 3,
                                'post__not_in'   => array(get_the_ID()),
                                'orderby'        => 'rand'
                            );
                            $related_query = new WP_Query($related_args);
                            if ($related_query->have_posts()) :
                                while ($related_query->have_posts()) : $related_query->the_post(); ?>
                                    <li style="display: flex; align-items: center; margin-bottom: 10px;">
                                        <?php if (has_post_thumbnail()) : ?>
                                            <img src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="<?php the_title(); ?>"
                                                style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px; aspect-ratio: 3/2;">
                                        <?php else : ?>
                                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default.jpg"
                                                alt="No Image" style="width: 60px; height: 40px; border-radius: 5px; margin-right: 10px;">
                                        <?php endif; ?>
                                        <a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), 10); ?></a>
                                    </li>
                            <?php endwhile;
                                wp_reset_postdata();
                            endif;
                            ?>
                        </ul>
                    </div>

                    <!-- Services -->
                    <?php
                    $services = get_option('services_data', []);
                    ?>

                    <div class="more-project mb-4 serr bc">
                        <h3>Our Services</h3>
                        <div class="stroke-shape"></div>

                        <ul class="service-list">
                            <?php if (!empty($services) && is_array($services)) : ?>
                                <?php foreach ($services as $index => $service) :

                                    $title = !empty($service['service_title']) ? esc_html($service['service_title']) : false;

                                    $image_id = !empty($service['image']) ? intval($service['image']) : 0;
                                    $image_url = $image_id ? wp_get_attachment_url($image_id) : get_template_directory_uri() . '/admin/assets/img/trans.png';
                                    $slug = $title ? sanitize_title($title) : '';

                                    if (!$title) {
                                        echo "<li style='color:red;'>Service #$index is missing title</li>";
                                        continue;
                                    }
                                ?>
                                    <li class="service-item d-flex align-items-center mb-2">
                                        <a href="<?php echo esc_url(home_url('/service/' . $slug)); ?>">
                                            <?php echo $title; ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <li style="color: orange;">No services found in option array.</li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </aside>
            </div>
        </div>
    </section>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
    $(document).ready(function() {
        $('#project-slider').carousel({
            interval: 3000,
            pause: 'hover'
        });
    });
</script>

<?php include "footer.php"; ?>